# SmartVolution\V1customersApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createCustomer**](V1customersApi.md#createCustomer) | **POST** /v1/customers | Create a customer in the system
[**deleteCustomerById**](V1customersApi.md#deleteCustomerById) | **DELETE** /v1/customers/{id} | Deletes a customer by their id
[**findCustomerById**](V1customersApi.md#findCustomerById) | **GET** /v1/customers/{id} | Gets Customer details by their id
[**getAllCustomers**](V1customersApi.md#getAllCustomers) | **GET** /v1/customers | Gets a list of all the Customer for a tenant
[**putCustomer**](V1customersApi.md#putCustomer) | **PUT** /v1/customers | Performs an &#39;update or insert&#39; of a customer based on its code
[**updateCustomer**](V1customersApi.md#updateCustomer) | **PATCH** /v1/customers | Edit an existing customer in the system


# **createCustomer**
> createCustomer($customer)

Create a customer in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer = new \SmartVolution\Model\CustomerIn(); // \SmartVolution\Model\CustomerIn | Customer object that need to be created

try {
    $apiInstance->createCustomer($customer);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->createCustomer: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer** | [**\SmartVolution\Model\CustomerIn**](../Model/CustomerIn.md)| Customer object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCustomerById**
> deleteCustomerById($id)

Deletes a customer by their id

Non-Destructive in the database (Customer are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of customer to delete

try {
    $apiInstance->deleteCustomerById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->deleteCustomerById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of customer to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findCustomerById**
> \SmartVolution\Model\AllFieldCustomer findCustomerById($id)

Gets Customer details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of customer to query

try {
    $result = $apiInstance->findCustomerById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->findCustomerById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of customer to query |

### Return type

[**\SmartVolution\Model\AllFieldCustomer**](../Model/AllFieldCustomer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllCustomers**
> \SmartVolution\Model\AllFieldCustomer[] getAllCustomers($tenant, $since, $deleted, $basic, $store, $clerk, $search)

Gets a list of all the Customer for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$basic = true; // bool | Shows only basic information of records
$store = 789; // int | The preferrence store id
$clerk = 789; // int | The preferrence clerk id
$search = "search_example"; // string | Search the email and first name, last name,

try {
    $result = $apiInstance->getAllCustomers($tenant, $since, $deleted, $basic, $store, $clerk, $search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->getAllCustomers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **basic** | **bool**| Shows only basic information of records | [optional]
 **store** | **int**| The preferrence store id | [optional]
 **clerk** | **int**| The preferrence clerk id | [optional]
 **search** | **string**| Search the email and first name, last name, | [optional]

### Return type

[**\SmartVolution\Model\AllFieldCustomer[]**](../Model/AllFieldCustomer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCustomer**
> putCustomer($customer)

Performs an 'update or insert' of a customer based on its code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customer = new \SmartVolution\Model\CustomerInOver(); // \SmartVolution\Model\CustomerInOver | Customer object containing edited fields

try {
    $apiInstance->putCustomer($customer);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->putCustomer: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer** | [**\SmartVolution\Model\CustomerInOver**](../Model/CustomerInOver.md)| Customer object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateCustomer**
> updateCustomer($customerInEdit)

Edit an existing customer in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerInEdit = new \SmartVolution\Model\CustomerInEdit(); // \SmartVolution\Model\CustomerInEdit | Customer object containing edited fields

try {
    $apiInstance->updateCustomer($customerInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1customersApi->updateCustomer: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerInEdit** | [**\SmartVolution\Model\CustomerInEdit**](../Model/CustomerInEdit.md)| Customer object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

