# SmartVolution\V1cashDenominationsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createCD**](V1cashDenominationsApi.md#createCD) | **POST** /v1/cashDenominations | Create a cash denomination in the system
[**deleteCDById**](V1cashDenominationsApi.md#deleteCDById) | **DELETE** /v1/cashDenominations/{id} | Deletes a cash denomination by their id
[**findCDById**](V1cashDenominationsApi.md#findCDById) | **GET** /v1/cashDenominations/{id} | Gets cash denomination details by id
[**getAllCashDenominations**](V1cashDenominationsApi.md#getAllCashDenominations) | **GET** /v1/cashDenominations | Gets a list of all the cash denominations for a tenant
[**updateCD**](V1cashDenominationsApi.md#updateCD) | **PATCH** /v1/cashDenominations | edit an existing Cash Denomination in the system


# **createCD**
> createCD($cashDenomination)

Create a cash denomination in the system



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1cashDenominationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cashDenomination = new \SmartVolution\Model\CashDenominationsIn(); // \SmartVolution\Model\CashDenominationsIn | CD object that need to be created

try {
    $apiInstance->createCD($cashDenomination);
} catch (Exception $e) {
    echo 'Exception when calling V1cashDenominationsApi->createCD: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cashDenomination** | [**\SmartVolution\Model\CashDenominationsIn**](../Model/CashDenominationsIn.md)| CD object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCDById**
> deleteCDById($id)

Deletes a cash denomination by their id

Non-Destructive in the database (Cash Denomination are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1cashDenominationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of user to delete

try {
    $apiInstance->deleteCDById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1cashDenominationsApi->deleteCDById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of user to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findCDById**
> \SmartVolution\Model\Tax findCDById($id)

Gets cash denomination details by id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1cashDenominationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Cash Denomination to query

try {
    $result = $apiInstance->findCDById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1cashDenominationsApi->findCDById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Cash Denomination to query |

### Return type

[**\SmartVolution\Model\Tax**](../Model/Tax.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllCashDenominations**
> \SmartVolution\Model\CashDenominations[] getAllCashDenominations($tenant, $since, $deleted)

Gets a list of all the cash denominations for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1cashDenominationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllCashDenominations($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1cashDenominationsApi->getAllCashDenominations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\CashDenominations[]**](../Model/CashDenominations.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateCD**
> updateCD($cashDenominationInEdit)

edit an existing Cash Denomination in the system



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1cashDenominationsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$cashDenominationInEdit = new \SmartVolution\Model\CashDenominationsInEdit(); // \SmartVolution\Model\CashDenominationsInEdit | Cash Denomination object containing edited fields

try {
    $apiInstance->updateCD($cashDenominationInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1cashDenominationsApi->updateCD: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cashDenominationInEdit** | [**\SmartVolution\Model\CashDenominationsInEdit**](../Model/CashDenominationsInEdit.md)| Cash Denomination object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

