<?php
/**
 * V1transactionsApi
 * PHP version 5
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 4.15
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SmartVolution\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SmartVolution\ApiException;
use SmartVolution\Configuration;
use SmartVolution\HeaderSelector;
use SmartVolution\ObjectSerializer;

/**
 * V1transactionsApi Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class V1transactionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation batchLockSuspendedTransaction
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int[]
     */
    public function batchLockSuspendedTransaction($ids, $clerkId = null, $lock = null)
    {
        list($response) = $this->batchLockSuspendedTransactionWithHttpInfo($ids, $clerkId, $lock);
        return $response;
    }

    /**
     * Operation batchLockSuspendedTransactionWithHttpInfo
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int[], HTTP status code, HTTP response headers (array of strings)
     */
    public function batchLockSuspendedTransactionWithHttpInfo($ids, $clerkId = null, $lock = null)
    {
        $returnType = 'int[]';
        $request = $this->batchLockSuspendedTransactionRequest($ids, $clerkId, $lock);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation batchLockSuspendedTransactionAsync
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchLockSuspendedTransactionAsync($ids, $clerkId = null, $lock = null)
    {
        return $this->batchLockSuspendedTransactionAsyncWithHttpInfo($ids, $clerkId, $lock)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation batchLockSuspendedTransactionAsyncWithHttpInfo
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchLockSuspendedTransactionAsyncWithHttpInfo($ids, $clerkId = null, $lock = null)
    {
        $returnType = 'int[]';
        $request = $this->batchLockSuspendedTransactionRequest($ids, $clerkId, $lock);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'batchLockSuspendedTransaction'
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function batchLockSuspendedTransactionRequest($ids, $clerkId = null, $lock = null)
    {
        // verify the required parameter 'ids' is set
        if ($ids === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ids when calling batchLockSuspendedTransaction'
            );
        }

        $resourcePath = '/v1/batchLockSuspendedTransaction';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($ids)) {
            $ids = ObjectSerializer::serializeCollection($ids, 'csv', true);
        }
        if ($ids !== null) {
            $queryParams['ids'] = ObjectSerializer::toQueryValue($ids);
        }
        // query params
        if ($clerkId !== null) {
            $queryParams['clerkId'] = ObjectSerializer::toQueryValue($clerkId);
        }
        // query params
        if ($lock !== null) {
            $queryParams['lock'] = ObjectSerializer::toQueryValue($lock);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation batchLockSuspendedTransactionV2
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int[]
     */
    public function batchLockSuspendedTransactionV2($ids, $clerkId = null, $lock = null)
    {
        list($response) = $this->batchLockSuspendedTransactionV2WithHttpInfo($ids, $clerkId, $lock);
        return $response;
    }

    /**
     * Operation batchLockSuspendedTransactionV2WithHttpInfo
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int[], HTTP status code, HTTP response headers (array of strings)
     */
    public function batchLockSuspendedTransactionV2WithHttpInfo($ids, $clerkId = null, $lock = null)
    {
        $returnType = 'int[]';
        $request = $this->batchLockSuspendedTransactionV2Request($ids, $clerkId, $lock);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation batchLockSuspendedTransactionV2Async
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchLockSuspendedTransactionV2Async($ids, $clerkId = null, $lock = null)
    {
        return $this->batchLockSuspendedTransactionV2AsyncWithHttpInfo($ids, $clerkId, $lock)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation batchLockSuspendedTransactionV2AsyncWithHttpInfo
     *
     * Batch Lock Suspended Transactions
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function batchLockSuspendedTransactionV2AsyncWithHttpInfo($ids, $clerkId = null, $lock = null)
    {
        $returnType = 'int[]';
        $request = $this->batchLockSuspendedTransactionV2Request($ids, $clerkId, $lock);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'batchLockSuspendedTransactionV2'
     *
     * @param  int[] $ids ID list of Suspended Transaction to batch lock (required)
     * @param  int $clerkId ID of Staff to batch lock (optional)
     * @param  bool $lock Not used currently (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function batchLockSuspendedTransactionV2Request($ids, $clerkId = null, $lock = null)
    {
        // verify the required parameter 'ids' is set
        if ($ids === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $ids when calling batchLockSuspendedTransactionV2'
            );
        }

        $resourcePath = '/v2/batchLockSuspendedTransaction';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if (is_array($ids)) {
            $ids = ObjectSerializer::serializeCollection($ids, 'csv', true);
        }
        if ($ids !== null) {
            $queryParams['ids'] = ObjectSerializer::toQueryValue($ids);
        }
        // query params
        if ($clerkId !== null) {
            $queryParams['clerkId'] = ObjectSerializer::toQueryValue($clerkId);
        }
        // query params
        if ($lock !== null) {
            $queryParams['lock'] = ObjectSerializer::toQueryValue($lock);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTransaction
     *
     * Create a new transaction in the system
     *
     * @param  \SmartVolution\Model\Transaction $transaction Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\TransactionResponse
     */
    public function createTransaction($transaction)
    {
        list($response) = $this->createTransactionWithHttpInfo($transaction);
        return $response;
    }

    /**
     * Operation createTransactionWithHttpInfo
     *
     * Create a new transaction in the system
     *
     * @param  \SmartVolution\Model\Transaction $transaction Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\TransactionResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTransactionWithHttpInfo($transaction)
    {
        $returnType = '\SmartVolution\Model\TransactionResponse';
        $request = $this->createTransactionRequest($transaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\TransactionResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createTransactionAsync
     *
     * Create a new transaction in the system
     *
     * @param  \SmartVolution\Model\Transaction $transaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransactionAsync($transaction)
    {
        return $this->createTransactionAsyncWithHttpInfo($transaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createTransactionAsyncWithHttpInfo
     *
     * Create a new transaction in the system
     *
     * @param  \SmartVolution\Model\Transaction $transaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTransactionAsyncWithHttpInfo($transaction)
    {
        $returnType = '\SmartVolution\Model\TransactionResponse';
        $request = $this->createTransactionRequest($transaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTransaction'
     *
     * @param  \SmartVolution\Model\Transaction $transaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createTransactionRequest($transaction)
    {
        // verify the required parameter 'transaction' is set
        if ($transaction === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transaction when calling createTransaction'
            );
        }

        $resourcePath = '/v1/transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($transaction)) {
            $_tempBody = $transaction;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findPreAuthTransactionItems
     *
     * Check if exists Pre Auth Suspended Items
     *
     * @param  int $deviceId deviceId (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function findPreAuthTransactionItems($deviceId = null)
    {
        $this->findPreAuthTransactionItemsWithHttpInfo($deviceId);
    }

    /**
     * Operation findPreAuthTransactionItemsWithHttpInfo
     *
     * Check if exists Pre Auth Suspended Items
     *
     * @param  int $deviceId deviceId (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function findPreAuthTransactionItemsWithHttpInfo($deviceId = null)
    {
        $returnType = '';
        $request = $this->findPreAuthTransactionItemsRequest($deviceId);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation findPreAuthTransactionItemsAsync
     *
     * Check if exists Pre Auth Suspended Items
     *
     * @param  int $deviceId deviceId (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findPreAuthTransactionItemsAsync($deviceId = null)
    {
        return $this->findPreAuthTransactionItemsAsyncWithHttpInfo($deviceId)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findPreAuthTransactionItemsAsyncWithHttpInfo
     *
     * Check if exists Pre Auth Suspended Items
     *
     * @param  int $deviceId deviceId (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findPreAuthTransactionItemsAsyncWithHttpInfo($deviceId = null)
    {
        $returnType = '';
        $request = $this->findPreAuthTransactionItemsRequest($deviceId);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findPreAuthTransactionItems'
     *
     * @param  int $deviceId deviceId (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findPreAuthTransactionItemsRequest($deviceId = null)
    {

        $resourcePath = '/v1/suspend/findPreAuthTransactionItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($deviceId !== null) {
            $queryParams['deviceId'] = ObjectSerializer::toQueryValue($deviceId);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionById
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransactionOut
     */
    public function findSuspendedTransactionById($id, $clerkId = null, $noLock = null)
    {
        list($response) = $this->findSuspendedTransactionByIdWithHttpInfo($id, $clerkId, $noLock);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByIdWithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransactionOut, HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByIdWithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdRequest($id, $clerkId, $noLock);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransactionOut',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByIdAsync
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdAsync($id, $clerkId = null, $noLock = null)
    {
        return $this->findSuspendedTransactionByIdAsyncWithHttpInfo($id, $clerkId, $noLock)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByIdAsyncWithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdAsyncWithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdRequest($id, $clerkId, $noLock);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionById'
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByIdRequest($id, $clerkId = null, $noLock = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findSuspendedTransactionById'
            );
        }

        $resourcePath = '/v1/suspended/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($clerkId !== null) {
            $queryParams['clerkId'] = ObjectSerializer::toQueryValue($clerkId);
        }
        // query params
        if ($noLock !== null) {
            $queryParams['noLock'] = ObjectSerializer::toQueryValue($noLock);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionByIdV2
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransactionOut
     */
    public function findSuspendedTransactionByIdV2($id, $clerkId = null, $noLock = null)
    {
        list($response) = $this->findSuspendedTransactionByIdV2WithHttpInfo($id, $clerkId, $noLock);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByIdV2WithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransactionOut, HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByIdV2WithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdV2Request($id, $clerkId, $noLock);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransactionOut',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByIdV2Async
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdV2Async($id, $clerkId = null, $noLock = null)
    {
        return $this->findSuspendedTransactionByIdV2AsyncWithHttpInfo($id, $clerkId, $noLock)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByIdV2AsyncWithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdV2AsyncWithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdV2Request($id, $clerkId, $noLock);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionByIdV2'
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByIdV2Request($id, $clerkId = null, $noLock = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findSuspendedTransactionByIdV2'
            );
        }

        $resourcePath = '/v2/suspended/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($clerkId !== null) {
            $queryParams['clerkId'] = ObjectSerializer::toQueryValue($clerkId);
        }
        // query params
        if ($noLock !== null) {
            $queryParams['noLock'] = ObjectSerializer::toQueryValue($noLock);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionByIdV3
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransactionOut
     */
    public function findSuspendedTransactionByIdV3($id, $clerkId = null, $noLock = null)
    {
        list($response) = $this->findSuspendedTransactionByIdV3WithHttpInfo($id, $clerkId, $noLock);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByIdV3WithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransactionOut, HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByIdV3WithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdV3Request($id, $clerkId, $noLock);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransactionOut',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByIdV3Async
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdV3Async($id, $clerkId = null, $noLock = null)
    {
        return $this->findSuspendedTransactionByIdV3AsyncWithHttpInfo($id, $clerkId, $noLock)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByIdV3AsyncWithHttpInfo
     *
     * Gets suspended transaction details by their id
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByIdV3AsyncWithHttpInfo($id, $clerkId = null, $noLock = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut';
        $request = $this->findSuspendedTransactionByIdV3Request($id, $clerkId, $noLock);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionByIdV3'
     *
     * @param  int $id Id of suspended transaction to query (required)
     * @param  int $clerkId Id of clerk to query (optional)
     * @param  bool $noLock Lock of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByIdV3Request($id, $clerkId = null, $noLock = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findSuspendedTransactionByIdV3'
            );
        }

        $resourcePath = '/v3/suspended/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($clerkId !== null) {
            $queryParams['clerkId'] = ObjectSerializer::toQueryValue($clerkId);
        }
        // query params
        if ($noLock !== null) {
            $queryParams['noLock'] = ObjectSerializer::toQueryValue($noLock);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionByReference
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransaction[]
     */
    public function findSuspendedTransactionByReference($reference, $readyToComplete = null)
    {
        list($response) = $this->findSuspendedTransactionByReferenceWithHttpInfo($reference, $readyToComplete);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByReferenceWithHttpInfo
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransaction[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByReferenceWithHttpInfo($reference, $readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->findSuspendedTransactionByReferenceRequest($reference, $readyToComplete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByReferenceAsync
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByReferenceAsync($reference, $readyToComplete = null)
    {
        return $this->findSuspendedTransactionByReferenceAsyncWithHttpInfo($reference, $readyToComplete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByReferenceAsyncWithHttpInfo
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByReferenceAsyncWithHttpInfo($reference, $readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->findSuspendedTransactionByReferenceRequest($reference, $readyToComplete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionByReference'
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByReferenceRequest($reference, $readyToComplete = null)
    {
        // verify the required parameter 'reference' is set
        if ($reference === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reference when calling findSuspendedTransactionByReference'
            );
        }

        $resourcePath = '/v1/suspend/findSuspendedTransactionByReference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($reference !== null) {
            $queryParams['reference'] = ObjectSerializer::toQueryValue($reference);
        }
        // query params
        if ($readyToComplete !== null) {
            $queryParams['readyToComplete'] = ObjectSerializer::toQueryValue($readyToComplete);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionByReferenceV2
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransaction[]
     */
    public function findSuspendedTransactionByReferenceV2($reference, $readyToComplete = null)
    {
        list($response) = $this->findSuspendedTransactionByReferenceV2WithHttpInfo($reference, $readyToComplete);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByReferenceV2WithHttpInfo
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransaction[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByReferenceV2WithHttpInfo($reference, $readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->findSuspendedTransactionByReferenceV2Request($reference, $readyToComplete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByReferenceV2Async
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByReferenceV2Async($reference, $readyToComplete = null)
    {
        return $this->findSuspendedTransactionByReferenceV2AsyncWithHttpInfo($reference, $readyToComplete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByReferenceV2AsyncWithHttpInfo
     *
     * Gets a list of used reference that contains suspended transactions
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByReferenceV2AsyncWithHttpInfo($reference, $readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->findSuspendedTransactionByReferenceV2Request($reference, $readyToComplete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionByReferenceV2'
     *
     * @param  string $reference (required)
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByReferenceV2Request($reference, $readyToComplete = null)
    {
        // verify the required parameter 'reference' is set
        if ($reference === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reference when calling findSuspendedTransactionByReferenceV2'
            );
        }

        $resourcePath = '/v2/suspend/findSuspendedTransactionByReference';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($reference !== null) {
            $queryParams['reference'] = ObjectSerializer::toQueryValue($reference);
        }
        // query params
        if ($readyToComplete !== null) {
            $queryParams['readyToComplete'] = ObjectSerializer::toQueryValue($readyToComplete);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findSuspendedTransactionByTillNumber
     *
     * Gets a list of SuspendedTransactions' references by storeId and till number
     *
     * @param  string $tillNumber tillNumber (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string[]
     */
    public function findSuspendedTransactionByTillNumber($tillNumber)
    {
        list($response) = $this->findSuspendedTransactionByTillNumberWithHttpInfo($tillNumber);
        return $response;
    }

    /**
     * Operation findSuspendedTransactionByTillNumberWithHttpInfo
     *
     * Gets a list of SuspendedTransactions' references by storeId and till number
     *
     * @param  string $tillNumber tillNumber (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string[], HTTP status code, HTTP response headers (array of strings)
     */
    public function findSuspendedTransactionByTillNumberWithHttpInfo($tillNumber)
    {
        $returnType = 'string[]';
        $request = $this->findSuspendedTransactionByTillNumberRequest($tillNumber);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'string[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findSuspendedTransactionByTillNumberAsync
     *
     * Gets a list of SuspendedTransactions' references by storeId and till number
     *
     * @param  string $tillNumber tillNumber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByTillNumberAsync($tillNumber)
    {
        return $this->findSuspendedTransactionByTillNumberAsyncWithHttpInfo($tillNumber)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findSuspendedTransactionByTillNumberAsyncWithHttpInfo
     *
     * Gets a list of SuspendedTransactions' references by storeId and till number
     *
     * @param  string $tillNumber tillNumber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findSuspendedTransactionByTillNumberAsyncWithHttpInfo($tillNumber)
    {
        $returnType = 'string[]';
        $request = $this->findSuspendedTransactionByTillNumberRequest($tillNumber);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findSuspendedTransactionByTillNumber'
     *
     * @param  string $tillNumber tillNumber (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findSuspendedTransactionByTillNumberRequest($tillNumber)
    {
        // verify the required parameter 'tillNumber' is set
        if ($tillNumber === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $tillNumber when calling findSuspendedTransactionByTillNumber'
            );
        }

        $resourcePath = '/v1/suspendedReferences';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tillNumber !== null) {
            $queryParams['tillNumber'] = ObjectSerializer::toQueryValue($tillNumber);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findTransactionById
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\TransactionOut
     */
    public function findTransactionById($id, $local = null)
    {
        list($response) = $this->findTransactionByIdWithHttpInfo($id, $local);
        return $response;
    }

    /**
     * Operation findTransactionByIdWithHttpInfo
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\TransactionOut, HTTP status code, HTTP response headers (array of strings)
     */
    public function findTransactionByIdWithHttpInfo($id, $local = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut';
        $request = $this->findTransactionByIdRequest($id, $local);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\TransactionOut',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findTransactionByIdAsync
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findTransactionByIdAsync($id, $local = null)
    {
        return $this->findTransactionByIdAsyncWithHttpInfo($id, $local)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findTransactionByIdAsyncWithHttpInfo
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findTransactionByIdAsyncWithHttpInfo($id, $local = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut';
        $request = $this->findTransactionByIdRequest($id, $local);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findTransactionById'
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findTransactionByIdRequest($id, $local = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findTransactionById'
            );
        }

        $resourcePath = '/v1/transactions/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($local !== null) {
            $queryParams['local'] = ObjectSerializer::toQueryValue($local);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findTransactionByIdV2
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\TransactionOut
     */
    public function findTransactionByIdV2($id, $local = null)
    {
        list($response) = $this->findTransactionByIdV2WithHttpInfo($id, $local);
        return $response;
    }

    /**
     * Operation findTransactionByIdV2WithHttpInfo
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\TransactionOut, HTTP status code, HTTP response headers (array of strings)
     */
    public function findTransactionByIdV2WithHttpInfo($id, $local = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut';
        $request = $this->findTransactionByIdV2Request($id, $local);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\TransactionOut',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findTransactionByIdV2Async
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findTransactionByIdV2Async($id, $local = null)
    {
        return $this->findTransactionByIdV2AsyncWithHttpInfo($id, $local)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findTransactionByIdV2AsyncWithHttpInfo
     *
     * Gets transaction details by their id
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findTransactionByIdV2AsyncWithHttpInfo($id, $local = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut';
        $request = $this->findTransactionByIdV2Request($id, $local);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findTransactionByIdV2'
     *
     * @param  int $id Id of transaction to query (required)
     * @param  bool $local Id of transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findTransactionByIdV2Request($id, $local = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findTransactionByIdV2'
            );
        }

        $resourcePath = '/v2/transactions/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($local !== null) {
            $queryParams['local'] = ObjectSerializer::toQueryValue($local);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllSuspendedTransactions
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransaction[]
     */
    public function getAllSuspendedTransactions()
    {
        list($response) = $this->getAllSuspendedTransactionsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getAllSuspendedTransactionsWithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransaction[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllSuspendedTransactionsWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->getAllSuspendedTransactionsRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransaction[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllSuspendedTransactionsAsync
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsAsync()
    {
        return $this->getAllSuspendedTransactionsAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllSuspendedTransactionsAsyncWithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsAsyncWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\SuspendedTransaction[]';
        $request = $this->getAllSuspendedTransactionsRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllSuspendedTransactions'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllSuspendedTransactionsRequest()
    {

        $resourcePath = '/v1/suspended';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllSuspendedTransactionsV2
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransactionOut[]
     */
    public function getAllSuspendedTransactionsV2($readyToComplete = null)
    {
        list($response) = $this->getAllSuspendedTransactionsV2WithHttpInfo($readyToComplete);
        return $response;
    }

    /**
     * Operation getAllSuspendedTransactionsV2WithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransactionOut[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllSuspendedTransactionsV2WithHttpInfo($readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut[]';
        $request = $this->getAllSuspendedTransactionsV2Request($readyToComplete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransactionOut[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllSuspendedTransactionsV2Async
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsV2Async($readyToComplete = null)
    {
        return $this->getAllSuspendedTransactionsV2AsyncWithHttpInfo($readyToComplete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllSuspendedTransactionsV2AsyncWithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsV2AsyncWithHttpInfo($readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut[]';
        $request = $this->getAllSuspendedTransactionsV2Request($readyToComplete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllSuspendedTransactionsV2'
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllSuspendedTransactionsV2Request($readyToComplete = null)
    {

        $resourcePath = '/v2/suspended';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($readyToComplete !== null) {
            $queryParams['readyToComplete'] = ObjectSerializer::toQueryValue($readyToComplete);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllSuspendedTransactionsV3
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\SuspendedTransactionOut[]
     */
    public function getAllSuspendedTransactionsV3($readyToComplete = null)
    {
        list($response) = $this->getAllSuspendedTransactionsV3WithHttpInfo($readyToComplete);
        return $response;
    }

    /**
     * Operation getAllSuspendedTransactionsV3WithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\SuspendedTransactionOut[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllSuspendedTransactionsV3WithHttpInfo($readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut[]';
        $request = $this->getAllSuspendedTransactionsV3Request($readyToComplete);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\SuspendedTransactionOut[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllSuspendedTransactionsV3Async
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsV3Async($readyToComplete = null)
    {
        return $this->getAllSuspendedTransactionsV3AsyncWithHttpInfo($readyToComplete)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllSuspendedTransactionsV3AsyncWithHttpInfo
     *
     * Gets a list of all the suspended transactions for a tenant
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllSuspendedTransactionsV3AsyncWithHttpInfo($readyToComplete = null)
    {
        $returnType = '\SmartVolution\Model\SuspendedTransactionOut[]';
        $request = $this->getAllSuspendedTransactionsV3Request($readyToComplete);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllSuspendedTransactionsV3'
     *
     * @param  bool $readyToComplete readyToComplete of suspended transaction to query (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllSuspendedTransactionsV3Request($readyToComplete = null)
    {

        $resourcePath = '/v3/suspended';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($readyToComplete !== null) {
            $queryParams['readyToComplete'] = ObjectSerializer::toQueryValue($readyToComplete);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllTransactions
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\TransactionOut[]
     */
    public function getAllTransactions($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null)
    {
        list($response) = $this->getAllTransactionsWithHttpInfo($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal);
        return $response;
    }

    /**
     * Operation getAllTransactionsWithHttpInfo
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\TransactionOut[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllTransactionsWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut[]';
        $request = $this->getAllTransactionsRequest($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\TransactionOut[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllTransactionsAsync
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransactionsAsync($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null)
    {
        return $this->getAllTransactionsAsyncWithHttpInfo($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllTransactionsAsyncWithHttpInfo
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransactionsAsyncWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut[]';
        $request = $this->getAllTransactionsRequest($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllTransactions'
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllTransactionsRequest($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null)
    {

        $resourcePath = '/v1/transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if (is_array($store)) {
            $store = ObjectSerializer::serializeCollection($store, 'csv', true);
        }
        if ($store !== null) {
            $queryParams['store'] = ObjectSerializer::toQueryValue($store);
        }
        // query params
        if (is_array($clerk)) {
            $clerk = ObjectSerializer::serializeCollection($clerk, 'csv', true);
        }
        if ($clerk !== null) {
            $queryParams['clerk'] = ObjectSerializer::toQueryValue($clerk);
        }
        // query params
        if ($customer !== null) {
            $queryParams['customer'] = ObjectSerializer::toQueryValue($customer);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime);
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime);
        }
        // query params
        if ($since !== null) {
            $queryParams['since'] = ObjectSerializer::toQueryValue($since);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = ObjectSerializer::toQueryValue($deleted);
        }
        // query params
        if ($isBasic !== null) {
            $queryParams['isBasic'] = ObjectSerializer::toQueryValue($isBasic);
        }
        // query params
        if ($cardPan !== null) {
            $queryParams['cardPan'] = ObjectSerializer::toQueryValue($cardPan);
        }
        // query params
        if ($localTransactionId !== null) {
            $queryParams['localTransactionId'] = ObjectSerializer::toQueryValue($localTransactionId);
        }
        // query params
        if ($includeReversal !== null) {
            $queryParams['includeReversal'] = ObjectSerializer::toQueryValue($includeReversal);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllTransactionsV2
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     * @param  bool $isForRefund Return whether transction list include transction that only contain items of type REFUND (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\TransactionOut[]
     */
    public function getAllTransactionsV2($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null, $isForRefund = null)
    {
        list($response) = $this->getAllTransactionsV2WithHttpInfo($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal, $isForRefund);
        return $response;
    }

    /**
     * Operation getAllTransactionsV2WithHttpInfo
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     * @param  bool $isForRefund Return whether transction list include transction that only contain items of type REFUND (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\TransactionOut[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllTransactionsV2WithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null, $isForRefund = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut[]';
        $request = $this->getAllTransactionsV2Request($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal, $isForRefund);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\TransactionOut[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllTransactionsV2Async
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     * @param  bool $isForRefund Return whether transction list include transction that only contain items of type REFUND (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransactionsV2Async($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null, $isForRefund = null)
    {
        return $this->getAllTransactionsV2AsyncWithHttpInfo($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal, $isForRefund)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllTransactionsV2AsyncWithHttpInfo
     *
     * Gets a list of all the transactions for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     * @param  bool $isForRefund Return whether transction list include transction that only contain items of type REFUND (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllTransactionsV2AsyncWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null, $isForRefund = null)
    {
        $returnType = '\SmartVolution\Model\TransactionOut[]';
        $request = $this->getAllTransactionsV2Request($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal, $isForRefund);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllTransactionsV2'
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00+00:00 (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     * @param  bool $isBasic Return detail or not (optional)
     * @param  string $cardPan CardPan of Transactions to query (optional)
     * @param  string $localTransactionId localTransactionId of transactions to query (optional)
     * @param  bool $includeReversal Return reversal transaciton and its parent or not (optional)
     * @param  bool $isForRefund Return whether transction list include transction that only contain items of type REFUND (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllTransactionsV2Request($tenant = null, $store = null, $clerk = null, $customer = null, $startTime = null, $endTime = null, $since = null, $deleted = null, $isBasic = null, $cardPan = null, $localTransactionId = null, $includeReversal = null, $isForRefund = null)
    {

        $resourcePath = '/v2/transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if (is_array($store)) {
            $store = ObjectSerializer::serializeCollection($store, 'csv', true);
        }
        if ($store !== null) {
            $queryParams['store'] = ObjectSerializer::toQueryValue($store);
        }
        // query params
        if (is_array($clerk)) {
            $clerk = ObjectSerializer::serializeCollection($clerk, 'csv', true);
        }
        if ($clerk !== null) {
            $queryParams['clerk'] = ObjectSerializer::toQueryValue($clerk);
        }
        // query params
        if ($customer !== null) {
            $queryParams['customer'] = ObjectSerializer::toQueryValue($customer);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime);
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime);
        }
        // query params
        if ($since !== null) {
            $queryParams['since'] = ObjectSerializer::toQueryValue($since);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = ObjectSerializer::toQueryValue($deleted);
        }
        // query params
        if ($isBasic !== null) {
            $queryParams['isBasic'] = ObjectSerializer::toQueryValue($isBasic);
        }
        // query params
        if ($cardPan !== null) {
            $queryParams['cardPan'] = ObjectSerializer::toQueryValue($cardPan);
        }
        // query params
        if ($localTransactionId !== null) {
            $queryParams['localTransactionId'] = ObjectSerializer::toQueryValue($localTransactionId);
        }
        // query params
        if ($includeReversal !== null) {
            $queryParams['includeReversal'] = ObjectSerializer::toQueryValue($includeReversal);
        }
        // query params
        if ($isForRefund !== null) {
            $queryParams['isForRefund'] = ObjectSerializer::toQueryValue($isForRefund);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuspendedClerks
     *
     * Gets a list of clerks that contains suspended transactions
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int[]
     */
    public function getSuspendedClerks()
    {
        list($response) = $this->getSuspendedClerksWithHttpInfo();
        return $response;
    }

    /**
     * Operation getSuspendedClerksWithHttpInfo
     *
     * Gets a list of clerks that contains suspended transactions
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuspendedClerksWithHttpInfo()
    {
        $returnType = 'int[]';
        $request = $this->getSuspendedClerksRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSuspendedClerksAsync
     *
     * Gets a list of clerks that contains suspended transactions
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuspendedClerksAsync()
    {
        return $this->getSuspendedClerksAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSuspendedClerksAsyncWithHttpInfo
     *
     * Gets a list of clerks that contains suspended transactions
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuspendedClerksAsyncWithHttpInfo()
    {
        $returnType = 'int[]';
        $request = $this->getSuspendedClerksRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuspendedClerks'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getSuspendedClerksRequest()
    {

        $resourcePath = '/v1/suspendedClerks';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuspendedReasons
     *
     * Gets a list of used reasons that contains suspended transactions
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int[]
     */
    public function getSuspendedReasons()
    {
        list($response) = $this->getSuspendedReasonsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getSuspendedReasonsWithHttpInfo
     *
     * Gets a list of used reasons that contains suspended transactions
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuspendedReasonsWithHttpInfo()
    {
        $returnType = 'int[]';
        $request = $this->getSuspendedReasonsRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getSuspendedReasonsAsync
     *
     * Gets a list of used reasons that contains suspended transactions
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuspendedReasonsAsync()
    {
        return $this->getSuspendedReasonsAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSuspendedReasonsAsyncWithHttpInfo
     *
     * Gets a list of used reasons that contains suspended transactions
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuspendedReasonsAsyncWithHttpInfo()
    {
        $returnType = 'int[]';
        $request = $this->getSuspendedReasonsRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuspendedReasons'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getSuspendedReasonsRequest()
    {

        $resourcePath = '/v1/suspendedReasons';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTextsRemainingNotification
     *
     * Gets texts remaining notification when the texts remaining lower than text re-order limit
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\ClientNotification
     */
    public function getTextsRemainingNotification()
    {
        list($response) = $this->getTextsRemainingNotificationWithHttpInfo();
        return $response;
    }

    /**
     * Operation getTextsRemainingNotificationWithHttpInfo
     *
     * Gets texts remaining notification when the texts remaining lower than text re-order limit
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\ClientNotification, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTextsRemainingNotificationWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\ClientNotification';
        $request = $this->getTextsRemainingNotificationRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\ClientNotification',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getTextsRemainingNotificationAsync
     *
     * Gets texts remaining notification when the texts remaining lower than text re-order limit
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTextsRemainingNotificationAsync()
    {
        return $this->getTextsRemainingNotificationAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getTextsRemainingNotificationAsyncWithHttpInfo
     *
     * Gets texts remaining notification when the texts remaining lower than text re-order limit
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTextsRemainingNotificationAsyncWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\ClientNotification';
        $request = $this->getTextsRemainingNotificationRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTextsRemainingNotification'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getTextsRemainingNotificationRequest()
    {

        $resourcePath = '/v1/textsRemainingNotification';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation putSuspendedTransaction
     *
     * Put a suspended transaction in the system
     *
     * @param  \SmartVolution\Model\SuspendedTransactionInPut $suspendedTransaction Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return int
     */
    public function putSuspendedTransaction($suspendedTransaction)
    {
        list($response) = $this->putSuspendedTransactionWithHttpInfo($suspendedTransaction);
        return $response;
    }

    /**
     * Operation putSuspendedTransactionWithHttpInfo
     *
     * Put a suspended transaction in the system
     *
     * @param  \SmartVolution\Model\SuspendedTransactionInPut $suspendedTransaction Transaction object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of int, HTTP status code, HTTP response headers (array of strings)
     */
    public function putSuspendedTransactionWithHttpInfo($suspendedTransaction)
    {
        $returnType = 'int';
        $request = $this->putSuspendedTransactionRequest($suspendedTransaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'int',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation putSuspendedTransactionAsync
     *
     * Put a suspended transaction in the system
     *
     * @param  \SmartVolution\Model\SuspendedTransactionInPut $suspendedTransaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSuspendedTransactionAsync($suspendedTransaction)
    {
        return $this->putSuspendedTransactionAsyncWithHttpInfo($suspendedTransaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation putSuspendedTransactionAsyncWithHttpInfo
     *
     * Put a suspended transaction in the system
     *
     * @param  \SmartVolution\Model\SuspendedTransactionInPut $suspendedTransaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function putSuspendedTransactionAsyncWithHttpInfo($suspendedTransaction)
    {
        $returnType = 'int';
        $request = $this->putSuspendedTransactionRequest($suspendedTransaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'putSuspendedTransaction'
     *
     * @param  \SmartVolution\Model\SuspendedTransactionInPut $suspendedTransaction Transaction object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function putSuspendedTransactionRequest($suspendedTransaction)
    {
        // verify the required parameter 'suspendedTransaction' is set
        if ($suspendedTransaction === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $suspendedTransaction when calling putSuspendedTransaction'
            );
        }

        $resourcePath = '/v1/suspended';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($suspendedTransaction)) {
            $_tempBody = $suspendedTransaction;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTransaction
     *
     * Edit an existing transaction in the system
     *
     * @param  \SmartVolution\Model\TransactionInEdit $transaction Transaction object containing edited fields (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateTransaction($transaction)
    {
        $this->updateTransactionWithHttpInfo($transaction);
    }

    /**
     * Operation updateTransactionWithHttpInfo
     *
     * Edit an existing transaction in the system
     *
     * @param  \SmartVolution\Model\TransactionInEdit $transaction Transaction object containing edited fields (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTransactionWithHttpInfo($transaction)
    {
        $returnType = '';
        $request = $this->updateTransactionRequest($transaction);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateTransactionAsync
     *
     * Edit an existing transaction in the system
     *
     * @param  \SmartVolution\Model\TransactionInEdit $transaction Transaction object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTransactionAsync($transaction)
    {
        return $this->updateTransactionAsyncWithHttpInfo($transaction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateTransactionAsyncWithHttpInfo
     *
     * Edit an existing transaction in the system
     *
     * @param  \SmartVolution\Model\TransactionInEdit $transaction Transaction object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTransactionAsyncWithHttpInfo($transaction)
    {
        $returnType = '';
        $request = $this->updateTransactionRequest($transaction);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTransaction'
     *
     * @param  \SmartVolution\Model\TransactionInEdit $transaction Transaction object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateTransactionRequest($transaction)
    {
        // verify the required parameter 'transaction' is set
        if ($transaction === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $transaction when calling updateTransaction'
            );
        }

        $resourcePath = '/v1/transactions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($transaction)) {
            $_tempBody = $transaction;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
