<?php
/**
 * V1reportsApi
 * PHP version 5
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 4.15
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SmartVolution\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SmartVolution\ApiException;
use SmartVolution\Configuration;
use SmartVolution\HeaderSelector;
use SmartVolution\ObjectSerializer;

/**
 * V1reportsApi Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class V1reportsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getAllReportsForTenant
     *
     * Gets all the products that should be displayed in the browser for a device
     *
     * @param  int $groupId report group id (required)
     * @param  int $tenant tenant id (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\ProductBrowserMapping[]
     */
    public function getAllReportsForTenant($groupId, $tenant = null)
    {
        list($response) = $this->getAllReportsForTenantWithHttpInfo($groupId, $tenant);
        return $response;
    }

    /**
     * Operation getAllReportsForTenantWithHttpInfo
     *
     * Gets all the products that should be displayed in the browser for a device
     *
     * @param  int $groupId report group id (required)
     * @param  int $tenant tenant id (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\ProductBrowserMapping[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllReportsForTenantWithHttpInfo($groupId, $tenant = null)
    {
        $returnType = '\SmartVolution\Model\ProductBrowserMapping[]';
        $request = $this->getAllReportsForTenantRequest($groupId, $tenant);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\ProductBrowserMapping[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllReportsForTenantAsync
     *
     * Gets all the products that should be displayed in the browser for a device
     *
     * @param  int $groupId report group id (required)
     * @param  int $tenant tenant id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllReportsForTenantAsync($groupId, $tenant = null)
    {
        return $this->getAllReportsForTenantAsyncWithHttpInfo($groupId, $tenant)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllReportsForTenantAsyncWithHttpInfo
     *
     * Gets all the products that should be displayed in the browser for a device
     *
     * @param  int $groupId report group id (required)
     * @param  int $tenant tenant id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllReportsForTenantAsyncWithHttpInfo($groupId, $tenant = null)
    {
        $returnType = '\SmartVolution\Model\ProductBrowserMapping[]';
        $request = $this->getAllReportsForTenantRequest($groupId, $tenant);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllReportsForTenant'
     *
     * @param  int $groupId report group id (required)
     * @param  int $tenant tenant id (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllReportsForTenantRequest($groupId, $tenant = null)
    {
        // verify the required parameter 'groupId' is set
        if ($groupId === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $groupId when calling getAllReportsForTenant'
            );
        }

        $resourcePath = '/v1/reports';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if ($groupId !== null) {
            $queryParams['groupId'] = ObjectSerializer::toQueryValue($groupId);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReportById
     *
     * Calculates a report between two datetimes
     *
     * @param  int $id Id of report to query (required)
     * @param  \DateTime $start start datetime eg 2015-07-07T14:43:00+01:00 (required)
     * @param  \DateTime $end end datetime eg 2015-07-07T14:43:00+00:01 (required)
     * @param  int $tenant tenant data to query (optional)
     * @param  string $timeZone eg +01:00 (optional)
     * @param  int $device device id as a filter (optional)
     * @param  int[] $store store id as a filter (optional)
     * @param  int[] $dept dept id as a filter (optional)
     * @param  int[] $supplier supplier id as a filter (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\Report[]
     */
    public function getReportById($id, $start, $end, $tenant = null, $timeZone = null, $device = null, $store = null, $dept = null, $supplier = null)
    {
        list($response) = $this->getReportByIdWithHttpInfo($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);
        return $response;
    }

    /**
     * Operation getReportByIdWithHttpInfo
     *
     * Calculates a report between two datetimes
     *
     * @param  int $id Id of report to query (required)
     * @param  \DateTime $start start datetime eg 2015-07-07T14:43:00+01:00 (required)
     * @param  \DateTime $end end datetime eg 2015-07-07T14:43:00+00:01 (required)
     * @param  int $tenant tenant data to query (optional)
     * @param  string $timeZone eg +01:00 (optional)
     * @param  int $device device id as a filter (optional)
     * @param  int[] $store store id as a filter (optional)
     * @param  int[] $dept dept id as a filter (optional)
     * @param  int[] $supplier supplier id as a filter (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\Report[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getReportByIdWithHttpInfo($id, $start, $end, $tenant = null, $timeZone = null, $device = null, $store = null, $dept = null, $supplier = null)
    {
        $returnType = '\SmartVolution\Model\Report[]';
        $request = $this->getReportByIdRequest($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\Report[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReportByIdAsync
     *
     * Calculates a report between two datetimes
     *
     * @param  int $id Id of report to query (required)
     * @param  \DateTime $start start datetime eg 2015-07-07T14:43:00+01:00 (required)
     * @param  \DateTime $end end datetime eg 2015-07-07T14:43:00+00:01 (required)
     * @param  int $tenant tenant data to query (optional)
     * @param  string $timeZone eg +01:00 (optional)
     * @param  int $device device id as a filter (optional)
     * @param  int[] $store store id as a filter (optional)
     * @param  int[] $dept dept id as a filter (optional)
     * @param  int[] $supplier supplier id as a filter (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReportByIdAsync($id, $start, $end, $tenant = null, $timeZone = null, $device = null, $store = null, $dept = null, $supplier = null)
    {
        return $this->getReportByIdAsyncWithHttpInfo($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReportByIdAsyncWithHttpInfo
     *
     * Calculates a report between two datetimes
     *
     * @param  int $id Id of report to query (required)
     * @param  \DateTime $start start datetime eg 2015-07-07T14:43:00+01:00 (required)
     * @param  \DateTime $end end datetime eg 2015-07-07T14:43:00+00:01 (required)
     * @param  int $tenant tenant data to query (optional)
     * @param  string $timeZone eg +01:00 (optional)
     * @param  int $device device id as a filter (optional)
     * @param  int[] $store store id as a filter (optional)
     * @param  int[] $dept dept id as a filter (optional)
     * @param  int[] $supplier supplier id as a filter (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReportByIdAsyncWithHttpInfo($id, $start, $end, $tenant = null, $timeZone = null, $device = null, $store = null, $dept = null, $supplier = null)
    {
        $returnType = '\SmartVolution\Model\Report[]';
        $request = $this->getReportByIdRequest($id, $start, $end, $tenant, $timeZone, $device, $store, $dept, $supplier);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReportById'
     *
     * @param  int $id Id of report to query (required)
     * @param  \DateTime $start start datetime eg 2015-07-07T14:43:00+01:00 (required)
     * @param  \DateTime $end end datetime eg 2015-07-07T14:43:00+00:01 (required)
     * @param  int $tenant tenant data to query (optional)
     * @param  string $timeZone eg +01:00 (optional)
     * @param  int $device device id as a filter (optional)
     * @param  int[] $store store id as a filter (optional)
     * @param  int[] $dept dept id as a filter (optional)
     * @param  int[] $supplier supplier id as a filter (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getReportByIdRequest($id, $start, $end, $tenant = null, $timeZone = null, $device = null, $store = null, $dept = null, $supplier = null)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getReportById'
            );
        }
        // verify the required parameter 'start' is set
        if ($start === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $start when calling getReportById'
            );
        }
        // verify the required parameter 'end' is set
        if ($end === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $end when calling getReportById'
            );
        }

        $resourcePath = '/v1/reports/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if ($start !== null) {
            $queryParams['start'] = ObjectSerializer::toQueryValue($start);
        }
        // query params
        if ($end !== null) {
            $queryParams['end'] = ObjectSerializer::toQueryValue($end);
        }
        // query params
        if ($timeZone !== null) {
            $queryParams['timeZone'] = ObjectSerializer::toQueryValue($timeZone);
        }
        // query params
        if ($device !== null) {
            $queryParams['device'] = ObjectSerializer::toQueryValue($device);
        }
        // query params
        if (is_array($store)) {
            $store = ObjectSerializer::serializeCollection($store, 'csv', true);
        }
        if ($store !== null) {
            $queryParams['store'] = ObjectSerializer::toQueryValue($store);
        }
        // query params
        if (is_array($dept)) {
            $dept = ObjectSerializer::serializeCollection($dept, 'csv', true);
        }
        if ($dept !== null) {
            $queryParams['dept'] = ObjectSerializer::toQueryValue($dept);
        }
        // query params
        if (is_array($supplier)) {
            $supplier = ObjectSerializer::serializeCollection($supplier, 'csv', true);
        }
        if ($supplier !== null) {
            $queryParams['supplier'] = ObjectSerializer::toQueryValue($supplier);
        }

        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReportGroups
     *
     * Gets data of report groups for a tenant
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\ReportGroup[]
     */
    public function getReportGroups()
    {
        list($response) = $this->getReportGroupsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getReportGroupsWithHttpInfo
     *
     * Gets data of report groups for a tenant
     *
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\ReportGroup[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getReportGroupsWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\ReportGroup[]';
        $request = $this->getReportGroupsRequest();

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\ReportGroup[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getReportGroupsAsync
     *
     * Gets data of report groups for a tenant
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReportGroupsAsync()
    {
        return $this->getReportGroupsAsyncWithHttpInfo()
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getReportGroupsAsyncWithHttpInfo
     *
     * Gets data of report groups for a tenant
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReportGroupsAsyncWithHttpInfo()
    {
        $returnType = '\SmartVolution\Model\ReportGroup[]';
        $request = $this->getReportGroupsRequest();

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReportGroups'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getReportGroupsRequest()
    {

        $resourcePath = '/v1/reportGroups';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
