# SmartVolution\V1tenderTypesApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTenderType**](V1tenderTypesApi.md#createTenderType) | **POST** /v1/tenderTypes | Create a tender type in the system
[**deleteTenderTypeById**](V1tenderTypesApi.md#deleteTenderTypeById) | **DELETE** /v1/tenderTypes/{id} | Deletes a tender type by their id
[**findTenderTypeById**](V1tenderTypesApi.md#findTenderTypeById) | **GET** /v1/tenderTypes/{id} | Gets TenderType details by their id
[**getAllTenderTypes**](V1tenderTypesApi.md#getAllTenderTypes) | **GET** /v1/tenderTypes | Gets a list of all the TenderType for a tenant
[**updateTenderType**](V1tenderTypesApi.md#updateTenderType) | **PATCH** /v1/tenderTypes | Edit an existing tender type in the system


# **createTenderType**
> createTenderType($tenderType)

Create a tender type in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenderTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenderType = new \SmartVolution\Model\TenderTypeIn(); // \SmartVolution\Model\TenderTypeIn | Tender Type object that need to be created

try {
    $apiInstance->createTenderType($tenderType);
} catch (Exception $e) {
    echo 'Exception when calling V1tenderTypesApi->createTenderType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenderType** | [**\SmartVolution\Model\TenderTypeIn**](../Model/TenderTypeIn.md)| Tender Type object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTenderTypeById**
> deleteTenderTypeById($id)

Deletes a tender type by their id

Non-Destructive in the database (Tender type are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenderTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Tender Type to delete

try {
    $apiInstance->deleteTenderTypeById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1tenderTypesApi->deleteTenderTypeById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Tender Type to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findTenderTypeById**
> \SmartVolution\Model\TenderType findTenderTypeById($id)

Gets TenderType details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenderTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Tender Type to query

try {
    $result = $apiInstance->findTenderTypeById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1tenderTypesApi->findTenderTypeById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Tender Type to query |

### Return type

[**\SmartVolution\Model\TenderType**](../Model/TenderType.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTenderTypes**
> \SmartVolution\Model\TenderType[] getAllTenderTypes($tenant, $since, $deleted)

Gets a list of all the TenderType for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenderTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllTenderTypes($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1tenderTypesApi->getAllTenderTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\TenderType[]**](../Model/TenderType.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateTenderType**
> updateTenderType($tenderType)

Edit an existing tender type in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenderTypesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenderType = new \SmartVolution\Model\TenderTypeInEdit(); // \SmartVolution\Model\TenderTypeInEdit | Tender type object containing edited fields

try {
    $apiInstance->updateTenderType($tenderType);
} catch (Exception $e) {
    echo 'Exception when calling V1tenderTypesApi->updateTenderType: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenderType** | [**\SmartVolution\Model\TenderTypeInEdit**](../Model/TenderTypeInEdit.md)| Tender type object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

