# SmartVolution\V1tenantsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTenant**](V1tenantsApi.md#createTenant) | **POST** /v1/tenants | Create a new clerk in the system
[**deleteTenantById**](V1tenantsApi.md#deleteTenantById) | **DELETE** /v1/tenants/{id} | Deletes a tenant by their id
[**getAllTenantsForTenant**](V1tenantsApi.md#getAllTenantsForTenant) | **GET** /v1/tenants | Gets a list of all the accessible for a tenant
[**getBillingTypes**](V1tenantsApi.md#getBillingTypes) | **GET** /v1/billingTypes | Get options of BillingTypes
[**getTenantById**](V1tenantsApi.md#getTenantById) | **GET** /v1/tenants/{id} | Gets all details for a tenant
[**updateTenant**](V1tenantsApi.md#updateTenant) | **PATCH** /v1/tenants | edit an existing clerk in the system


# **createTenant**
> createTenant($tenant)

Create a new clerk in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = new \SmartVolution\Model\TenantIn(); // \SmartVolution\Model\TenantIn | Tenant object that need to be created

try {
    $apiInstance->createTenant($tenant);
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->createTenant: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | [**\SmartVolution\Model\TenantIn**](../Model/TenantIn.md)| Tenant object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTenantById**
> deleteTenantById($id)

Deletes a tenant by their id

Non-Destructive in the database (tenants are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of tenant to delete

try {
    $apiInstance->deleteTenantById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->deleteTenantById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of tenant to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTenantsForTenant**
> \SmartVolution\Model\Tenant[] getAllTenantsForTenant($tenant, $toAbove)

Gets a list of all the accessible for a tenant

if no tenant id is passed then will default to the user tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$toAbove = true; // bool | If you want to query the parent tenants

try {
    $result = $apiInstance->getAllTenantsForTenant($tenant, $toAbove);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->getAllTenantsForTenant: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **toAbove** | **bool**| If you want to query the parent tenants | [optional]

### Return type

[**\SmartVolution\Model\Tenant[]**](../Model/Tenant.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getBillingTypes**
> getBillingTypes()

Get options of BillingTypes

Get options of BillingTypes

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $apiInstance->getBillingTypes();
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->getBillingTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTenantById**
> \SmartVolution\Model\Tenant getTenantById($id)

Gets all details for a tenant

if no tenant id is passed then will default to the user tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Tenant to query

try {
    $result = $apiInstance->getTenantById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->getTenantById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Tenant to query |

### Return type

[**\SmartVolution\Model\Tenant**](../Model/Tenant.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateTenant**
> updateTenant($tenant)

edit an existing clerk in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1tenantsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = new \SmartVolution\Model\TenantInEdit(); // \SmartVolution\Model\TenantInEdit | Tenant object containing edited fields

try {
    $apiInstance->updateTenant($tenant);
} catch (Exception $e) {
    echo 'Exception when calling V1tenantsApi->updateTenant: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | [**\SmartVolution\Model\TenantInEdit**](../Model/TenantInEdit.md)| Tenant object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

