# SmartVolution\V1supplierApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createSupplier**](V1supplierApi.md#createSupplier) | **POST** /v1/suppliers | Create a supplier in the system
[**deleteSupplierById**](V1supplierApi.md#deleteSupplierById) | **DELETE** /v1/suppliers/{id} | Deletes a supplier by their id
[**findSupplierById**](V1supplierApi.md#findSupplierById) | **GET** /v1/suppliers/{id} | Gets supplier details by their id
[**getAllSuppliers**](V1supplierApi.md#getAllSuppliers) | **GET** /v1/suppliers | Gets a list of all the supplier for a tenant
[**putSuppliers**](V1supplierApi.md#putSuppliers) | **PUT** /v1/suppliers | performs an &#39;update or insert&#39; of a supplier
[**updateSuppliers**](V1supplierApi.md#updateSuppliers) | **PATCH** /v1/suppliers | Edit an existing supplier in the system


# **createSupplier**
> createSupplier($supplier)

Create a supplier in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$supplier = new \SmartVolution\Model\SupplierIn(); // \SmartVolution\Model\SupplierIn | Supplier object that need to be created

try {
    $apiInstance->createSupplier($supplier);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->createSupplier: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **supplier** | [**\SmartVolution\Model\SupplierIn**](../Model/SupplierIn.md)| Supplier object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSupplierById**
> deleteSupplierById($id)

Deletes a supplier by their id

Non-Destructive in the database (Suppliers are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of supplier to delete

try {
    $apiInstance->deleteSupplierById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->deleteSupplierById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of supplier to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findSupplierById**
> \SmartVolution\Model\Supplier findSupplierById($id)

Gets supplier details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of supplier to query

try {
    $result = $apiInstance->findSupplierById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->findSupplierById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of supplier to query |

### Return type

[**\SmartVolution\Model\Supplier**](../Model/Supplier.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllSuppliers**
> \SmartVolution\Model\Supplier[] getAllSuppliers($tenant, $basic, $since, $search, $needTop)

Gets a list of all the supplier for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$basic = true; // bool | only show basic value, only for user
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$search = "search_example"; // string | search term to locate
$needTop = true; // bool | top 500 items return for each time

try {
    $result = $apiInstance->getAllSuppliers($tenant, $basic, $since, $search, $needTop);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->getAllSuppliers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **basic** | **bool**| only show basic value, only for user | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **search** | **string**| search term to locate | [optional]
 **needTop** | **bool**| top 500 items return for each time | [optional]

### Return type

[**\SmartVolution\Model\Supplier[]**](../Model/Supplier.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSuppliers**
> putSuppliers($supplier)

performs an 'update or insert' of a supplier



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$supplier = new \SmartVolution\Model\SupplierInOver(); // \SmartVolution\Model\SupplierInOver | Supplier object containing edited fields

try {
    $apiInstance->putSuppliers($supplier);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->putSuppliers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **supplier** | [**\SmartVolution\Model\SupplierInOver**](../Model/SupplierInOver.md)| Supplier object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateSuppliers**
> updateSuppliers($supplier)

Edit an existing supplier in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1supplierApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$supplier = new \SmartVolution\Model\SupplierInEdit(); // \SmartVolution\Model\SupplierInEdit | Supplier object containing edited fields

try {
    $apiInstance->updateSuppliers($supplier);
} catch (Exception $e) {
    echo 'Exception when calling V1supplierApi->updateSuppliers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **supplier** | [**\SmartVolution\Model\SupplierInEdit**](../Model/SupplierInEdit.md)| Supplier object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

