# SmartVolution\V1reasonsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createReason**](V1reasonsApi.md#createReason) | **POST** /v1/reasons | Create a reason in the Reasons
[**createReasonUsage**](V1reasonsApi.md#createReasonUsage) | **POST** /v1/reasons/usages | Create a new Reason Usage
[**deleteReasonById**](V1reasonsApi.md#deleteReasonById) | **DELETE** /v1/reasons/{id} | Deletes a reason by their id
[**deleteReasonUsage**](V1reasonsApi.md#deleteReasonUsage) | **DELETE** /v1/reasons/usages/{usage} | Deletes a reason usage by their tenant id and usage id
[**findReasonById**](V1reasonsApi.md#findReasonById) | **GET** /v1/reasons/{id} | Gets reasons by id
[**getAllReasons**](V1reasonsApi.md#getAllReasons) | **GET** /v1/reasons | Gets a list of all the reasons for a tenant
[**getReasonTypes**](V1reasonsApi.md#getReasonTypes) | **GET** /v1/reasons/usages | Gets usage values for reasons
[**getReasonUsage**](V1reasonsApi.md#getReasonUsage) | **GET** /v1/reasons/usages/{usage} | Gets usage by tenant id and usage id
[**updateReason**](V1reasonsApi.md#updateReason) | **PATCH** /v1/reasons | Edit an existing reason in the Reasons
[**updateReasonUsage**](V1reasonsApi.md#updateReasonUsage) | **PATCH** /v1/reasons/usages | Update a Reason Usage


# **createReason**
> createReason($reasons)

Create a reason in the Reasons

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reasons = new \SmartVolution\Model\ReasonsIn(); // \SmartVolution\Model\ReasonsIn | Reason object that need to be created

try {
    $apiInstance->createReason($reasons);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->createReason: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reasons** | [**\SmartVolution\Model\ReasonsIn**](../Model/ReasonsIn.md)| Reason object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createReasonUsage**
> createReasonUsage($reasonUsage)

Create a new Reason Usage

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reasonUsage = new \SmartVolution\Model\ReasonUsageIn(); // \SmartVolution\Model\ReasonUsageIn | Reason Usage object that need to be created

try {
    $apiInstance->createReasonUsage($reasonUsage);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->createReasonUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reasonUsage** | [**\SmartVolution\Model\ReasonUsageIn**](../Model/ReasonUsageIn.md)| Reason Usage object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReasonById**
> deleteReasonById($id)

Deletes a reason by their id

Non-Destructive in the database

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of reason to delete

try {
    $apiInstance->deleteReasonById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->deleteReasonById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of reason to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteReasonUsage**
> deleteReasonUsage($usage, $tenant)

Deletes a reason usage by their tenant id and usage id

Non-Destructive in the database

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$usage = 789; // int | usage of reason usage to delete
$tenant = 789; // int | id of tenant

try {
    $apiInstance->deleteReasonUsage($usage, $tenant);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->deleteReasonUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **usage** | **int**| usage of reason usage to delete |
 **tenant** | **int**| id of tenant | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findReasonById**
> \SmartVolution\Model\Reasons findReasonById($id, $isHidden)

Gets reasons by id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of reason to query
$isHidden = true; // bool | If isHidden is true, show including record that isHidden is true

try {
    $result = $apiInstance->findReasonById($id, $isHidden);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->findReasonById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of reason to query |
 **isHidden** | **bool**| If isHidden is true, show including record that isHidden is true | [optional]

### Return type

[**\SmartVolution\Model\Reasons**](../Model/Reasons.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllReasons**
> \SmartVolution\Model\Reasons[] getAllReasons($tenant, $usage, $since, $deleted, $isDefault, $isHidden)

Gets a list of all the reasons for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$usage = 789; // int | Usage of Reason to query
$since = 789; // int | Time of Modified to query
$deleted = true; // bool | Shows records that have been deleted
$isDefault = true; // bool | Shows records that isDefault is true
$isHidden = true; // bool | If isHidden is true, show including record that isHidden is true

try {
    $result = $apiInstance->getAllReasons($tenant, $usage, $since, $deleted, $isDefault, $isHidden);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->getAllReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **usage** | **int**| Usage of Reason to query | [optional]
 **since** | **int**| Time of Modified to query | [optional]
 **deleted** | **bool**| Shows records that have been deleted | [optional]
 **isDefault** | **bool**| Shows records that isDefault is true | [optional]
 **isHidden** | **bool**| If isHidden is true, show including record that isHidden is true | [optional]

### Return type

[**\SmartVolution\Model\Reasons[]**](../Model/Reasons.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReasonTypes**
> \SmartVolution\Model\ReasonUsage[] getReasonTypes($tenant, $deleted, $protect, $isHidden, $containItems)

Gets usage values for reasons

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$deleted = true; // bool | Shows records that have been deleted
$protect = true; // bool | Shows records that have been protected, if it is false, then it will only show the records where protected = 0, else it will show all
$isHidden = true; // bool | If isHidden is true, show including record that isHidden is true
$containItems = true; // bool | Shows records that have one or more items, if it is true, it will not return the list that does not contain any items

try {
    $result = $apiInstance->getReasonTypes($tenant, $deleted, $protect, $isHidden, $containItems);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->getReasonTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **deleted** | **bool**| Shows records that have been deleted | [optional]
 **protect** | **bool**| Shows records that have been protected, if it is false, then it will only show the records where protected &#x3D; 0, else it will show all | [optional]
 **isHidden** | **bool**| If isHidden is true, show including record that isHidden is true | [optional]
 **containItems** | **bool**| Shows records that have one or more items, if it is true, it will not return the list that does not contain any items | [optional]

### Return type

[**\SmartVolution\Model\ReasonUsage[]**](../Model/ReasonUsage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getReasonUsage**
> \SmartVolution\Model\ReasonUsage getReasonUsage($usage, $tenant, $isHidden)

Gets usage by tenant id and usage id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$usage = 789; // int | usage id to query
$tenant = 789; // int | tenant id to query
$isHidden = true; // bool | If isHidden is true, show including record that isHidden is true

try {
    $result = $apiInstance->getReasonUsage($usage, $tenant, $isHidden);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->getReasonUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **usage** | **int**| usage id to query |
 **tenant** | **int**| tenant id to query | [optional]
 **isHidden** | **bool**| If isHidden is true, show including record that isHidden is true | [optional]

### Return type

[**\SmartVolution\Model\ReasonUsage**](../Model/ReasonUsage.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReason**
> updateReason($reason)

Edit an existing reason in the Reasons

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reason = new \SmartVolution\Model\ReasonsInEdit(); // \SmartVolution\Model\ReasonsInEdit | Reason object containing edited fields

try {
    $apiInstance->updateReason($reason);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->updateReason: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reason** | [**\SmartVolution\Model\ReasonsInEdit**](../Model/ReasonsInEdit.md)| Reason object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateReasonUsage**
> updateReasonUsage($reasonUsage)

Update a Reason Usage

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1reasonsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reasonUsage = new \SmartVolution\Model\ReasonUsageInEdit(); // \SmartVolution\Model\ReasonUsageInEdit | Reason Usage object that need to be created

try {
    $apiInstance->updateReasonUsage($reasonUsage);
} catch (Exception $e) {
    echo 'Exception when calling V1reasonsApi->updateReasonUsage: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reasonUsage** | [**\SmartVolution\Model\ReasonUsageInEdit**](../Model/ReasonUsageInEdit.md)| Reason Usage object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

