# SmartVolution\V1printersApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createDevicePrinter**](V1printersApi.md#createDevicePrinter) | **POST** /v1/devices/printers | create device printer
[**createTenantPrinter**](V1printersApi.md#createTenantPrinter) | **POST** /v1/printers | create tenant printer
[**deleteDevicePrinterById**](V1printersApi.md#deleteDevicePrinterById) | **DELETE** /v1/devices/printers/{id} | Deletes a DevicePrinter by id
[**deleteTenantPrinterById**](V1printersApi.md#deleteTenantPrinterById) | **DELETE** /v1/printers/{id} | Deletes a TenantPrinter by id
[**getAllDevicePrinters**](V1printersApi.md#getAllDevicePrinters) | **GET** /v1/devices/printers | Get a list of all the device printers
[**getAllPrinterTypes**](V1printersApi.md#getAllPrinterTypes) | **GET** /v1/printerTypes | Get a list of all the printers
[**getAllTenantPrinters**](V1printersApi.md#getAllTenantPrinters) | **GET** /v1/printers | Get a list of all the tenant printers
[**getDevicePrinterById**](V1printersApi.md#getDevicePrinterById) | **GET** /v1/devices/printers/{id} | get a DevicePrinter by id
[**getPrinterTypeById**](V1printersApi.md#getPrinterTypeById) | **GET** /v1/printerTypes/{id} | Get a printers by id
[**getTenantPrinterById**](V1printersApi.md#getTenantPrinterById) | **GET** /v1/printers/{id} | Get a tenant printer by id
[**updateDevicePrinter**](V1printersApi.md#updateDevicePrinter) | **PATCH** /v1/devices/printers | update device printer
[**updateTenantPrinter**](V1printersApi.md#updateTenantPrinter) | **PATCH** /v1/printers | update tenant printer


# **createDevicePrinter**
> createDevicePrinter($devicePrinterIn)

create device printer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$devicePrinterIn = new \SmartVolution\Model\DevicePrinterIn(); // \SmartVolution\Model\DevicePrinterIn | DevicePrinter object that need to be created

try {
    $apiInstance->createDevicePrinter($devicePrinterIn);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->createDevicePrinter: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **devicePrinterIn** | [**\SmartVolution\Model\DevicePrinterIn**](../Model/DevicePrinterIn.md)| DevicePrinter object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createTenantPrinter**
> createTenantPrinter($tenantPrinterIn)

create tenant printer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenantPrinterIn = new \SmartVolution\Model\TenantPrinterIn(); // \SmartVolution\Model\TenantPrinterIn | TenantPrinter object that need to be created

try {
    $apiInstance->createTenantPrinter($tenantPrinterIn);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->createTenantPrinter: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenantPrinterIn** | [**\SmartVolution\Model\TenantPrinterIn**](../Model/TenantPrinterIn.md)| TenantPrinter object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteDevicePrinterById**
> deleteDevicePrinterById($id)

Deletes a DevicePrinter by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of TenantPrinter to delete

try {
    $apiInstance->deleteDevicePrinterById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->deleteDevicePrinterById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of TenantPrinter to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTenantPrinterById**
> deleteTenantPrinterById($id)

Deletes a TenantPrinter by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of TenantPrinter to delete

try {
    $apiInstance->deleteTenantPrinterById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->deleteTenantPrinterById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of TenantPrinter to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllDevicePrinters**
> \SmartVolution\Model\DevicePrinter[] getAllDevicePrinters($tenant, $since, $deleted)

Get a list of all the device printers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllDevicePrinters($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getAllDevicePrinters: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\DevicePrinter[]**](../Model/DevicePrinter.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllPrinterTypes**
> \SmartVolution\Model\Printer[] getAllPrinterTypes()

Get a list of all the printers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllPrinterTypes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getAllPrinterTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\Printer[]**](../Model/Printer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTenantPrinters**
> \SmartVolution\Model\TenantPrinter[] getAllTenantPrinters($tenant, $since, $deleted)

Get a list of all the tenant printers



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllTenantPrinters($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getAllTenantPrinters: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\TenantPrinter[]**](../Model/TenantPrinter.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDevicePrinterById**
> getDevicePrinterById($id)

get a DevicePrinter by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of DevicePrinter to delete

try {
    $apiInstance->getDevicePrinterById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getDevicePrinterById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of DevicePrinter to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPrinterTypeById**
> \SmartVolution\Model\Printer getPrinterTypeById($id)

Get a printers by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of printer to query

try {
    $result = $apiInstance->getPrinterTypeById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getPrinterTypeById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of printer to query |

### Return type

[**\SmartVolution\Model\Printer**](../Model/Printer.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTenantPrinterById**
> \SmartVolution\Model\TenantPrinter getTenantPrinterById($id)

Get a tenant printer by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of TenantPrinter to query

try {
    $result = $apiInstance->getTenantPrinterById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->getTenantPrinterById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of TenantPrinter to query |

### Return type

[**\SmartVolution\Model\TenantPrinter**](../Model/TenantPrinter.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateDevicePrinter**
> updateDevicePrinter($devicePrinterInEdit)

update device printer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$devicePrinterInEdit = new \SmartVolution\Model\DevicePrinterInEdit(); // \SmartVolution\Model\DevicePrinterInEdit | DevicePrinter object that need to be updated

try {
    $apiInstance->updateDevicePrinter($devicePrinterInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->updateDevicePrinter: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **devicePrinterInEdit** | [**\SmartVolution\Model\DevicePrinterInEdit**](../Model/DevicePrinterInEdit.md)| DevicePrinter object that need to be updated |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateTenantPrinter**
> updateTenantPrinter($tenantPrinterInEdit)

update tenant printer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1printersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenantPrinterInEdit = new \SmartVolution\Model\TenantPrinterInEdit(); // \SmartVolution\Model\TenantPrinterInEdit | TenantPrinter object that need to be updated

try {
    $apiInstance->updateTenantPrinter($tenantPrinterInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1printersApi->updateTenantPrinter: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenantPrinterInEdit** | [**\SmartVolution\Model\TenantPrinterInEdit**](../Model/TenantPrinterInEdit.md)| TenantPrinter object that need to be updated |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

