<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace SmartVolution;

use SmartVolution\Api\V1authApi;
use SmartVolution\Api\V1enrollApi;
use SmartVolution\Api\V1productsApi;
use SmartVolution\Model\Product;

class Examples extends \PHPUnit_Framework_TestCase
{
    // need to set these constants
    const USERNAME = '';
    const PASSWORD = '';
    const PROVISION_CODE = '';
    const TOKEN = '';

    public function testAuthenticate()
    {
        try {

            $client = ClientBuilder::getClient('http://dev.smartvolution.com:9003', '', null);

            $endpoint = new V1authApi($client);

            $auth = $endpoint->authenticate(self::USERNAME, self::PASSWORD);

            $data = json_decode($auth);

            $token = $data->token;

            return $token;

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testEnroll()
    {
        try {

            $client = ClientBuilder::getClient('http://dev.smartvolution.com:9003', '', null);

            $endpoint = new V1enrollApi($client);

            $enroll = $endpoint->enroll(self::PROVISION_CODE);

            $data = json_decode($enroll);

            $id = $data->id;
            $token = $data->authToken;

            return $token;

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProducts()
    {
        try {

            $client = ClientBuilder::getClient('http://dev.smartvolution.com:9003', self::TOKEN, null);

            $endpoint = new V1productsApi($client);

            $products = $endpoint->getAllProducts();

            /** @var Product $product */
            $product = $products[0];

            $productId = $product->getId();

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductImage()
    {
        try {

            $client = ClientBuilder::getClient('http://dev.smartvolution.com:9003', self::TOKEN, null);

            $endpoint = new V1productsApi($client);

            $productImage = $endpoint->getImageForProduct(454270, true);

        } catch (ApiException $exception) {

            $error = $exception->getMessage();

        }
    }
}
