# SmartVolution\V1transferItemsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTransferItem**](V1transferItemsApi.md#createTransferItem) | **POST** /v1/transferItems | Create a new transferItem in the system
[**deleteTransferItemById**](V1transferItemsApi.md#deleteTransferItemById) | **GET** /v1/transferItems/delete/{transferItemId} | Deletes a transferItem by their id
[**getAllTransferItems**](V1transferItemsApi.md#getAllTransferItems) | **GET** /v1/transferItems | Gets a list of all the transfers items for a transfer
[**getTransferItemsById**](V1transferItemsApi.md#getTransferItemsById) | **GET** /v1/transferItems/{id} | Gets a transfers Item for a tenant
[**updateTransferItem**](V1transferItemsApi.md#updateTransferItem) | **PATCH** /v1/transferItems | Update a new transferItem in the system


# **createTransferItem**
> int createTransferItem($transferItem)

Create a new transferItem in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transferItem = new \SmartVolution\Model\TransferItemIn(); // \SmartVolution\Model\TransferItemIn | TransferItem object that need to be created

try {
    $result = $apiInstance->createTransferItem($transferItem);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transferItemsApi->createTransferItem: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transferItem** | [**\SmartVolution\Model\TransferItemIn**](../Model/TransferItemIn.md)| TransferItem object that need to be created |

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteTransferItemById**
> \SmartVolution\Model\TransferItem[] deleteTransferItemById($transferItemId, $clerkId)

Deletes a transferItem by their id

Deletes a transferItem by their id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transferItemId = 789; // int | Id of transferItem to delete
$clerkId = 789; // int | Clerk if device login

try {
    $result = $apiInstance->deleteTransferItemById($transferItemId, $clerkId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transferItemsApi->deleteTransferItemById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transferItemId** | **int**| Id of transferItem to delete |
 **clerkId** | **int**| Clerk if device login |

### Return type

[**\SmartVolution\Model\TransferItem[]**](../Model/TransferItem.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTransferItems**
> \SmartVolution\Model\TransferItem[] getAllTransferItems($transfer)

Gets a list of all the transfers items for a transfer

Gets a list of all the transfers items for a transfer

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transfer = 789; // int | Id of transfer to query

try {
    $result = $apiInstance->getAllTransferItems($transfer);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transferItemsApi->getAllTransferItems: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transfer** | **int**| Id of transfer to query | [optional]

### Return type

[**\SmartVolution\Model\TransferItem[]**](../Model/TransferItem.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTransferItemsById**
> \SmartVolution\Model\TransferItem[] getTransferItemsById($id)

Gets a transfers Item for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of transferItem

try {
    $result = $apiInstance->getTransferItemsById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transferItemsApi->getTransferItemsById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of transferItem |

### Return type

[**\SmartVolution\Model\TransferItem[]**](../Model/TransferItem.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateTransferItem**
> updateTransferItem($transferItem)

Update a new transferItem in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transferItemsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transferItem = new \SmartVolution\Model\TransferItemEdit(); // \SmartVolution\Model\TransferItemEdit | Transaction object that need to be created

try {
    $apiInstance->updateTransferItem($transferItem);
} catch (Exception $e) {
    echo 'Exception when calling V1transferItemsApi->updateTransferItem: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transferItem** | [**\SmartVolution\Model\TransferItemEdit**](../Model/TransferItemEdit.md)| Transaction object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

