# SmartVolution\V1departmentsproductsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAllDepartmentProducts**](V1departmentsproductsApi.md#getAllDepartmentProducts) | **GET** /v1/departments/products | Gets a list of all the product department associations
[**getAllDepartmentProductsV2**](V1departmentsproductsApi.md#getAllDepartmentProductsV2) | **GET** /v2/departments/products | Gets a list of all the product department associations


# **getAllDepartmentProducts**
> \SmartVolution\Model\DepartmentProducts[] getAllDepartmentProducts($tenant, $since, $deleted)

Gets a list of all the product department associations

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsproductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllDepartmentProducts($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsproductsApi->getAllDepartmentProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\DepartmentProducts[]**](../Model/DepartmentProducts.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllDepartmentProductsV2**
> \SmartVolution\Model\DepartmentProducts[] getAllDepartmentProductsV2($tenant, $since, $deleted)

Gets a list of all the product department associations

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsproductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllDepartmentProductsV2($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsproductsApi->getAllDepartmentProductsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\DepartmentProducts[]**](../Model/DepartmentProducts.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

