# SmartVolution\V1appointmentsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createAppointment**](V1appointmentsApi.md#createAppointment) | **POST** /v1/appointments | Create a appointment in the system
[**deleteAppointmentById**](V1appointmentsApi.md#deleteAppointmentById) | **DELETE** /v1/appointments/{id} | Deletes a appointment by their id
[**findAppointmentById**](V1appointmentsApi.md#findAppointmentById) | **GET** /v1/appointments/{id} | Gets appointment details by their id
[**getAllAppointments**](V1appointmentsApi.md#getAllAppointments) | **GET** /v1/appointments | Gets a list of all the Appointment for a tenant
[**getAllAppointmentsV2**](V1appointmentsApi.md#getAllAppointmentsV2) | **GET** /v2/appointments | Gets a list of all the Appointment for a tenant
[**updateAppointment**](V1appointmentsApi.md#updateAppointment) | **PATCH** /v1/appointments | Edit an existing appointment in the system


# **createAppointment**
> createAppointment($appointmentIn)

Create a appointment in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$appointmentIn = new \SmartVolution\Model\AppointmentIn(); // \SmartVolution\Model\AppointmentIn | Appointment object that need to be created

try {
    $apiInstance->createAppointment($appointmentIn);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->createAppointment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appointmentIn** | [**\SmartVolution\Model\AppointmentIn**](../Model/AppointmentIn.md)| Appointment object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteAppointmentById**
> deleteAppointmentById($id)

Deletes a appointment by their id

Non-Destructive in the database (Appointment are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of appointment to delete

try {
    $apiInstance->deleteAppointmentById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->deleteAppointmentById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of appointment to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findAppointmentById**
> \SmartVolution\Model\AppointmentVii findAppointmentById($id)

Gets appointment details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of appointment to query

try {
    $result = $apiInstance->findAppointmentById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->findAppointmentById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of appointment to query |

### Return type

[**\SmartVolution\Model\AppointmentVii**](../Model/AppointmentVii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllAppointments**
> \SmartVolution\Model\Appointment[] getAllAppointments($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted)

Gets a list of all the Appointment for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$store = array(56); // int[] | Id of Store to query
$clerk = array(56); // int[] | Id of clerk to query
$customer = 789; // int | Id of customer to query
$appointmentType = array(56); // int[] | Appointment Type
$startTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Start datetime eg 2015-07-07T14:43:00Z
$endTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | End datetime eg 2015-07-07T14:43:00Z
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllAppointments($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->getAllAppointments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **store** | [**int[]**](../Model/int.md)| Id of Store to query | [optional]
 **clerk** | [**int[]**](../Model/int.md)| Id of clerk to query | [optional]
 **customer** | **int**| Id of customer to query | [optional]
 **appointmentType** | [**int[]**](../Model/int.md)| Appointment Type | [optional]
 **startTime** | **\DateTime**| Start datetime eg 2015-07-07T14:43:00Z | [optional]
 **endTime** | **\DateTime**| End datetime eg 2015-07-07T14:43:00Z | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\Appointment[]**](../Model/Appointment.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllAppointmentsV2**
> \SmartVolution\Model\AppointmentVii[] getAllAppointmentsV2($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted)

Gets a list of all the Appointment for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$store = array(56); // int[] | Id of Store to query
$clerk = array(56); // int[] | Id of clerk to query
$customer = 789; // int | Id of customer to query
$appointmentType = array(56); // int[] | Appointment Type
$startTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Start datetime eg 2015-07-07T14:43:00Z
$endTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | End datetime eg 2015-07-07T14:43:00Z
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllAppointmentsV2($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->getAllAppointmentsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **store** | [**int[]**](../Model/int.md)| Id of Store to query | [optional]
 **clerk** | [**int[]**](../Model/int.md)| Id of clerk to query | [optional]
 **customer** | **int**| Id of customer to query | [optional]
 **appointmentType** | [**int[]**](../Model/int.md)| Appointment Type | [optional]
 **startTime** | **\DateTime**| Start datetime eg 2015-07-07T14:43:00Z | [optional]
 **endTime** | **\DateTime**| End datetime eg 2015-07-07T14:43:00Z | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\AppointmentVii[]**](../Model/AppointmentVii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateAppointment**
> updateAppointment($appointmentInEdit)

Edit an existing appointment in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1appointmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$appointmentInEdit = new \SmartVolution\Model\AppointmentInEdit(); // \SmartVolution\Model\AppointmentInEdit | Appointment object containing edited fields

try {
    $apiInstance->updateAppointment($appointmentInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1appointmentsApi->updateAppointment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appointmentInEdit** | [**\SmartVolution\Model\AppointmentInEdit**](../Model/AppointmentInEdit.md)| Appointment object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

