<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace SmartVolution;

use GuzzleHttp\HandlerStack;
use GuzzleHttp\Client;
use Psr\Log\LoggerInterface;
use ConnectorSupport\Guzzle\Handler\Logger;

class ClientBuilder
{
    /**
     * @param string $baseUri
     * @param string $token
     * @param null|LoggerInterface $logger
     * @return Client
     */
    public static function getClient($baseUri, $token, LoggerInterface $logger = null)
    {
        $stack = HandlerStack::create();

        $request = Logger::create($logger);
        $stack->push($request);

        $client = new Client([

            'base_uri' => $baseUri,
            'headers' => ['cookie' => 'X-AUTH-TOKEN='.$token],
            'handler' => $stack

        ]);

        return $client;
    }
}