<?php
/**
 * V1appointmentsApi
 * PHP version 5
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * SV Register Web-services
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 4.12
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.3.1
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace SmartVolution\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SmartVolution\ApiException;
use SmartVolution\Configuration;
use SmartVolution\HeaderSelector;
use SmartVolution\ObjectSerializer;

/**
 * V1appointmentsApi Class Doc Comment
 *
 * @category Class
 * @package  SmartVolution
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class V1appointmentsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAppointment
     *
     * Create a appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentIn $appointmentIn Appointment object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createAppointment($appointmentIn)
    {
        $this->createAppointmentWithHttpInfo($appointmentIn);
    }

    /**
     * Operation createAppointmentWithHttpInfo
     *
     * Create a appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentIn $appointmentIn Appointment object that need to be created (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAppointmentWithHttpInfo($appointmentIn)
    {
        $returnType = '';
        $request = $this->createAppointmentRequest($appointmentIn);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation createAppointmentAsync
     *
     * Create a appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentIn $appointmentIn Appointment object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAppointmentAsync($appointmentIn)
    {
        return $this->createAppointmentAsyncWithHttpInfo($appointmentIn)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAppointmentAsyncWithHttpInfo
     *
     * Create a appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentIn $appointmentIn Appointment object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAppointmentAsyncWithHttpInfo($appointmentIn)
    {
        $returnType = '';
        $request = $this->createAppointmentRequest($appointmentIn);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAppointment'
     *
     * @param  \SmartVolution\Model\AppointmentIn $appointmentIn Appointment object that need to be created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createAppointmentRequest($appointmentIn)
    {
        // verify the required parameter 'appointmentIn' is set
        if ($appointmentIn === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $appointmentIn when calling createAppointment'
            );
        }

        $resourcePath = '/v1/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($appointmentIn)) {
            $_tempBody = $appointmentIn;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAppointmentById
     *
     * Deletes a appointment by their id
     *
     * @param  int $id Id of appointment to delete (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAppointmentById($id)
    {
        $this->deleteAppointmentByIdWithHttpInfo($id);
    }

    /**
     * Operation deleteAppointmentByIdWithHttpInfo
     *
     * Deletes a appointment by their id
     *
     * @param  int $id Id of appointment to delete (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAppointmentByIdWithHttpInfo($id)
    {
        $returnType = '';
        $request = $this->deleteAppointmentByIdRequest($id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAppointmentByIdAsync
     *
     * Deletes a appointment by their id
     *
     * @param  int $id Id of appointment to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAppointmentByIdAsync($id)
    {
        return $this->deleteAppointmentByIdAsyncWithHttpInfo($id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAppointmentByIdAsyncWithHttpInfo
     *
     * Deletes a appointment by their id
     *
     * @param  int $id Id of appointment to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAppointmentByIdAsyncWithHttpInfo($id)
    {
        $returnType = '';
        $request = $this->deleteAppointmentByIdRequest($id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAppointmentById'
     *
     * @param  int $id Id of appointment to delete (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteAppointmentByIdRequest($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteAppointmentById'
            );
        }

        $resourcePath = '/v1/appointments/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation findAppointmentById
     *
     * Gets appointment details by their id
     *
     * @param  int $id Id of appointment to query (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\AppointmentVii
     */
    public function findAppointmentById($id)
    {
        list($response) = $this->findAppointmentByIdWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation findAppointmentByIdWithHttpInfo
     *
     * Gets appointment details by their id
     *
     * @param  int $id Id of appointment to query (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\AppointmentVii, HTTP status code, HTTP response headers (array of strings)
     */
    public function findAppointmentByIdWithHttpInfo($id)
    {
        $returnType = '\SmartVolution\Model\AppointmentVii';
        $request = $this->findAppointmentByIdRequest($id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\AppointmentVii',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation findAppointmentByIdAsync
     *
     * Gets appointment details by their id
     *
     * @param  int $id Id of appointment to query (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAppointmentByIdAsync($id)
    {
        return $this->findAppointmentByIdAsyncWithHttpInfo($id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation findAppointmentByIdAsyncWithHttpInfo
     *
     * Gets appointment details by their id
     *
     * @param  int $id Id of appointment to query (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function findAppointmentByIdAsyncWithHttpInfo($id)
    {
        $returnType = '\SmartVolution\Model\AppointmentVii';
        $request = $this->findAppointmentByIdRequest($id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'findAppointmentById'
     *
     * @param  int $id Id of appointment to query (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function findAppointmentByIdRequest($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling findAppointmentById'
            );
        }

        $resourcePath = '/v1/appointments/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllAppointments
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\Appointment[]
     */
    public function getAllAppointments($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        list($response) = $this->getAllAppointmentsWithHttpInfo($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);
        return $response;
    }

    /**
     * Operation getAllAppointmentsWithHttpInfo
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\Appointment[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllAppointmentsWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        $returnType = '\SmartVolution\Model\Appointment[]';
        $request = $this->getAllAppointmentsRequest($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\Appointment[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllAppointmentsAsync
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAppointmentsAsync($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        return $this->getAllAppointmentsAsyncWithHttpInfo($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllAppointmentsAsyncWithHttpInfo
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAppointmentsAsyncWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        $returnType = '\SmartVolution\Model\Appointment[]';
        $request = $this->getAllAppointmentsRequest($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllAppointments'
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllAppointmentsRequest($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {

        $resourcePath = '/v1/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if (is_array($store)) {
            $store = ObjectSerializer::serializeCollection($store, 'csv', true);
        }
        if ($store !== null) {
            $queryParams['store'] = ObjectSerializer::toQueryValue($store);
        }
        // query params
        if (is_array($clerk)) {
            $clerk = ObjectSerializer::serializeCollection($clerk, 'csv', true);
        }
        if ($clerk !== null) {
            $queryParams['clerk'] = ObjectSerializer::toQueryValue($clerk);
        }
        // query params
        if ($customer !== null) {
            $queryParams['customer'] = ObjectSerializer::toQueryValue($customer);
        }
        // query params
        if (is_array($appointmentType)) {
            $appointmentType = ObjectSerializer::serializeCollection($appointmentType, 'csv', true);
        }
        if ($appointmentType !== null) {
            $queryParams['appointmentType'] = ObjectSerializer::toQueryValue($appointmentType);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime);
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime);
        }
        // query params
        if ($since !== null) {
            $queryParams['since'] = ObjectSerializer::toQueryValue($since);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = ObjectSerializer::toQueryValue($deleted);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllAppointmentsV2
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SmartVolution\Model\AppointmentVii[]
     */
    public function getAllAppointmentsV2($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        list($response) = $this->getAllAppointmentsV2WithHttpInfo($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);
        return $response;
    }

    /**
     * Operation getAllAppointmentsV2WithHttpInfo
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SmartVolution\Model\AppointmentVii[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllAppointmentsV2WithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        $returnType = '\SmartVolution\Model\AppointmentVii[]';
        $request = $this->getAllAppointmentsV2Request($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SmartVolution\Model\AppointmentVii[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllAppointmentsV2Async
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAppointmentsV2Async($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        return $this->getAllAppointmentsV2AsyncWithHttpInfo($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllAppointmentsV2AsyncWithHttpInfo
     *
     * Gets a list of all the Appointment for a tenant
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllAppointmentsV2AsyncWithHttpInfo($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {
        $returnType = '\SmartVolution\Model\AppointmentVii[]';
        $request = $this->getAllAppointmentsV2Request($tenant, $store, $clerk, $customer, $appointmentType, $startTime, $endTime, $since, $deleted);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllAppointmentsV2'
     *
     * @param  int $tenant Id of Tenant to query (optional)
     * @param  int[] $store Id of Store to query (optional)
     * @param  int[] $clerk Id of clerk to query (optional)
     * @param  int $customer Id of customer to query (optional)
     * @param  int[] $appointmentType Appointment Type (optional)
     * @param  \DateTime $startTime Start datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  \DateTime $endTime End datetime eg 2015-07-07T14:43:00Z (optional)
     * @param  int $since A time in seconds since midnight January 1st 1970 UTC (optional)
     * @param  bool $deleted Shows only records that have been deleted (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAllAppointmentsV2Request($tenant = null, $store = null, $clerk = null, $customer = null, $appointmentType = null, $startTime = null, $endTime = null, $since = null, $deleted = null)
    {

        $resourcePath = '/v2/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($tenant !== null) {
            $queryParams['tenant'] = ObjectSerializer::toQueryValue($tenant);
        }
        // query params
        if (is_array($store)) {
            $store = ObjectSerializer::serializeCollection($store, 'csv', true);
        }
        if ($store !== null) {
            $queryParams['store'] = ObjectSerializer::toQueryValue($store);
        }
        // query params
        if (is_array($clerk)) {
            $clerk = ObjectSerializer::serializeCollection($clerk, 'csv', true);
        }
        if ($clerk !== null) {
            $queryParams['clerk'] = ObjectSerializer::toQueryValue($clerk);
        }
        // query params
        if ($customer !== null) {
            $queryParams['customer'] = ObjectSerializer::toQueryValue($customer);
        }
        // query params
        if (is_array($appointmentType)) {
            $appointmentType = ObjectSerializer::serializeCollection($appointmentType, 'csv', true);
        }
        if ($appointmentType !== null) {
            $queryParams['appointmentType'] = ObjectSerializer::toQueryValue($appointmentType);
        }
        // query params
        if ($startTime !== null) {
            $queryParams['startTime'] = ObjectSerializer::toQueryValue($startTime);
        }
        // query params
        if ($endTime !== null) {
            $queryParams['endTime'] = ObjectSerializer::toQueryValue($endTime);
        }
        // query params
        if ($since !== null) {
            $queryParams['since'] = ObjectSerializer::toQueryValue($since);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = ObjectSerializer::toQueryValue($deleted);
        }


        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateAppointment
     *
     * Edit an existing appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentInEdit $appointmentInEdit Appointment object containing edited fields (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateAppointment($appointmentInEdit)
    {
        $this->updateAppointmentWithHttpInfo($appointmentInEdit);
    }

    /**
     * Operation updateAppointmentWithHttpInfo
     *
     * Edit an existing appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentInEdit $appointmentInEdit Appointment object containing edited fields (required)
     *
     * @throws \SmartVolution\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAppointmentWithHttpInfo($appointmentInEdit)
    {
        $returnType = '';
        $request = $this->updateAppointmentRequest($appointmentInEdit);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation updateAppointmentAsync
     *
     * Edit an existing appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentInEdit $appointmentInEdit Appointment object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAppointmentAsync($appointmentInEdit)
    {
        return $this->updateAppointmentAsyncWithHttpInfo($appointmentInEdit)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAppointmentAsyncWithHttpInfo
     *
     * Edit an existing appointment in the system
     *
     * @param  \SmartVolution\Model\AppointmentInEdit $appointmentInEdit Appointment object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAppointmentAsyncWithHttpInfo($appointmentInEdit)
    {
        $returnType = '';
        $request = $this->updateAppointmentRequest($appointmentInEdit);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateAppointment'
     *
     * @param  \SmartVolution\Model\AppointmentInEdit $appointmentInEdit Appointment object containing edited fields (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateAppointmentRequest($appointmentInEdit)
    {
        // verify the required parameter 'appointmentInEdit' is set
        if ($appointmentInEdit === null) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $appointmentInEdit when calling updateAppointment'
            );
        }

        $resourcePath = '/v1/appointments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($appointmentInEdit)) {
            $_tempBody = $appointmentInEdit;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PATCH',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
