# SmartVolution\V1uomApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getAllConversions**](V1uomApi.md#getAllConversions) | **GET** /v1/conversions | retrieves the conversions
[**getAllUoms**](V1uomApi.md#getAllUoms) | **GET** /v1/uom | retrieves the Uom


# **getAllConversions**
> \SmartVolution\Model\Conversion[] getAllConversions($since)

retrieves the conversions



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1uomApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC

try {
    $result = $apiInstance->getAllConversions($since);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1uomApi->getAllConversions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]

### Return type

[**\SmartVolution\Model\Conversion[]**](../Model/Conversion.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllUoms**
> \SmartVolution\Model\Uom[] getAllUoms($since, $productUomId, $selectedUomId)

retrieves the Uom



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1uomApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$productUomId = 789; // int | Measured uom from id
$selectedUomId = 789; // int | Measured uom for container product selected

try {
    $result = $apiInstance->getAllUoms($since, $productUomId, $selectedUomId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1uomApi->getAllUoms: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **productUomId** | **int**| Measured uom from id | [optional]
 **selectedUomId** | **int**| Measured uom for container product selected | [optional]

### Return type

[**\SmartVolution\Model\Uom[]**](../Model/Uom.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

