# SmartVolution\V1transactionsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTransaction**](V1transactionsApi.md#createTransaction) | **POST** /v1/transactions | Create a new transaction in the system
[**findPreAuthTransactionItems**](V1transactionsApi.md#findPreAuthTransactionItems) | **GET** /v1/suspend/findPreAuthTransactionItems | Check if exists Pre Auth Suspended Items
[**findSuspendedTransactionById**](V1transactionsApi.md#findSuspendedTransactionById) | **GET** /v1/suspended/{id} | Gets suspended transaction details by their id
[**findSuspendedTransactionByIdV2**](V1transactionsApi.md#findSuspendedTransactionByIdV2) | **GET** /v2/suspended/{id} | Gets suspended transaction details by their id
[**findSuspendedTransactionByReference**](V1transactionsApi.md#findSuspendedTransactionByReference) | **GET** /v1/suspend/findSuspendedTransactionByReference | Gets a list of used reference that contains suspended transactions
[**findSuspendedTransactionByReferenceV2**](V1transactionsApi.md#findSuspendedTransactionByReferenceV2) | **GET** /v2/suspend/findSuspendedTransactionByReference | Gets a list of used reference that contains suspended transactions
[**findTransactionById**](V1transactionsApi.md#findTransactionById) | **GET** /v1/transactions/{id} | Gets transaction details by their id
[**findTransactionByIdV2**](V1transactionsApi.md#findTransactionByIdV2) | **GET** /v2/transactions/{id} | Gets transaction details by their id
[**getAllSuspendedTransactions**](V1transactionsApi.md#getAllSuspendedTransactions) | **GET** /v1/suspended | Gets a list of all the suspended transactions for a tenant
[**getAllSuspendedTransactionsV2**](V1transactionsApi.md#getAllSuspendedTransactionsV2) | **GET** /v2/suspended | Gets a list of all the suspended transactions for a tenant
[**getAllSuspendedTransactionsV3**](V1transactionsApi.md#getAllSuspendedTransactionsV3) | **GET** /v3/suspended | Gets a list of all the suspended transactions for a tenant
[**getAllTransactions**](V1transactionsApi.md#getAllTransactions) | **GET** /v1/transactions | Gets a list of all the transactions for a tenant
[**getAllTransactionsV2**](V1transactionsApi.md#getAllTransactionsV2) | **GET** /v2/transactions | Gets a list of all the transactions for a tenant
[**getSuspendedClerks**](V1transactionsApi.md#getSuspendedClerks) | **GET** /v1/suspendedClerks | Gets a list of clerks that contains suspended transactions
[**getSuspendedReasons**](V1transactionsApi.md#getSuspendedReasons) | **GET** /v1/suspendedReasons | Gets a list of used reasons that contains suspended transactions
[**getTextsRemainingNotification**](V1transactionsApi.md#getTextsRemainingNotification) | **GET** /v1/textsRemainingNotification | Gets texts remaining notification when the texts remaining lower than text re-order limit
[**putSuspendedTransaction**](V1transactionsApi.md#putSuspendedTransaction) | **PUT** /v1/suspended | Put a suspended transaction in the system
[**updateTransaction**](V1transactionsApi.md#updateTransaction) | **PATCH** /v1/transactions | Edit an existing transaction in the system


# **createTransaction**
> int createTransaction($transaction)

Create a new transaction in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transaction = new \SmartVolution\Model\Transaction(); // \SmartVolution\Model\Transaction | Transaction object that need to be created

try {
    $result = $apiInstance->createTransaction($transaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->createTransaction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transaction** | [**\SmartVolution\Model\Transaction**](../Model/Transaction.md)| Transaction object that need to be created |

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findPreAuthTransactionItems**
> findPreAuthTransactionItems()

Check if exists Pre Auth Suspended Items

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $apiInstance->findPreAuthTransactionItems();
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findPreAuthTransactionItems: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findSuspendedTransactionById**
> \SmartVolution\Model\SuspendedTransactionOut findSuspendedTransactionById($id, $clerkId, $noLock)

Gets suspended transaction details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of suspended transaction to query
$clerkId = 789; // int | Id of clerk to query
$noLock = true; // bool | Lock of suspended transaction to query

try {
    $result = $apiInstance->findSuspendedTransactionById($id, $clerkId, $noLock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findSuspendedTransactionById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of suspended transaction to query |
 **clerkId** | **int**| Id of clerk to query | [optional]
 **noLock** | **bool**| Lock of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransactionOut**](../Model/SuspendedTransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findSuspendedTransactionByIdV2**
> \SmartVolution\Model\SuspendedTransactionOut findSuspendedTransactionByIdV2($id, $clerkId, $noLock)

Gets suspended transaction details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of suspended transaction to query
$clerkId = 789; // int | Id of clerk to query
$noLock = true; // bool | Lock of suspended transaction to query

try {
    $result = $apiInstance->findSuspendedTransactionByIdV2($id, $clerkId, $noLock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findSuspendedTransactionByIdV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of suspended transaction to query |
 **clerkId** | **int**| Id of clerk to query | [optional]
 **noLock** | **bool**| Lock of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransactionOut**](../Model/SuspendedTransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findSuspendedTransactionByReference**
> \SmartVolution\Model\SuspendedTransaction[] findSuspendedTransactionByReference($reference, $readyToComplete)

Gets a list of used reference that contains suspended transactions

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reference = "reference_example"; // string | 
$readyToComplete = true; // bool | readyToComplete of suspended transaction to query

try {
    $result = $apiInstance->findSuspendedTransactionByReference($reference, $readyToComplete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findSuspendedTransactionByReference: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reference** | **string**|  |
 **readyToComplete** | **bool**| readyToComplete of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransaction[]**](../Model/SuspendedTransaction.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findSuspendedTransactionByReferenceV2**
> \SmartVolution\Model\SuspendedTransaction[] findSuspendedTransactionByReferenceV2($reference, $readyToComplete)

Gets a list of used reference that contains suspended transactions

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$reference = "reference_example"; // string | 
$readyToComplete = true; // bool | readyToComplete of suspended transaction to query

try {
    $result = $apiInstance->findSuspendedTransactionByReferenceV2($reference, $readyToComplete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findSuspendedTransactionByReferenceV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **reference** | **string**|  |
 **readyToComplete** | **bool**| readyToComplete of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransaction[]**](../Model/SuspendedTransaction.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findTransactionById**
> \SmartVolution\Model\TransactionOut findTransactionById($id, $local)

Gets transaction details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of transaction to query
$local = true; // bool | Id of transaction to query

try {
    $result = $apiInstance->findTransactionById($id, $local);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findTransactionById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of transaction to query |
 **local** | **bool**| Id of transaction to query | [optional]

### Return type

[**\SmartVolution\Model\TransactionOut**](../Model/TransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findTransactionByIdV2**
> \SmartVolution\Model\TransactionOut findTransactionByIdV2($id, $local)

Gets transaction details by their id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of transaction to query
$local = true; // bool | Id of transaction to query

try {
    $result = $apiInstance->findTransactionByIdV2($id, $local);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->findTransactionByIdV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of transaction to query |
 **local** | **bool**| Id of transaction to query | [optional]

### Return type

[**\SmartVolution\Model\TransactionOut**](../Model/TransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllSuspendedTransactions**
> \SmartVolution\Model\SuspendedTransaction[] getAllSuspendedTransactions()

Gets a list of all the suspended transactions for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllSuspendedTransactions();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getAllSuspendedTransactions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\SuspendedTransaction[]**](../Model/SuspendedTransaction.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllSuspendedTransactionsV2**
> \SmartVolution\Model\SuspendedTransactionOut[] getAllSuspendedTransactionsV2($readyToComplete)

Gets a list of all the suspended transactions for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$readyToComplete = true; // bool | readyToComplete of suspended transaction to query

try {
    $result = $apiInstance->getAllSuspendedTransactionsV2($readyToComplete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getAllSuspendedTransactionsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **readyToComplete** | **bool**| readyToComplete of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransactionOut[]**](../Model/SuspendedTransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllSuspendedTransactionsV3**
> \SmartVolution\Model\SuspendedTransactionOut[] getAllSuspendedTransactionsV3($readyToComplete)

Gets a list of all the suspended transactions for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$readyToComplete = true; // bool | readyToComplete of suspended transaction to query

try {
    $result = $apiInstance->getAllSuspendedTransactionsV3($readyToComplete);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getAllSuspendedTransactionsV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **readyToComplete** | **bool**| readyToComplete of suspended transaction to query | [optional]

### Return type

[**\SmartVolution\Model\SuspendedTransactionOut[]**](../Model/SuspendedTransactionOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTransactions**
> \SmartVolution\Model\Transaction[] getAllTransactions($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal)

Gets a list of all the transactions for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$store = array(56); // int[] | Id of Store to query
$clerk = array(56); // int[] | Id of clerk to query
$customer = 789; // int | Id of customer to query
$startTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Start datetime eg 2015-07-07T14:43:00+00:00
$endTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | End datetime eg 2015-07-07T14:43:00+00:00
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$isBasic = true; // bool | Return detail or not
$cardPan = "cardPan_example"; // string | CardPan of Transactions to query
$localTransactionId = "localTransactionId_example"; // string | localTransactionId of transactions to query
$includeReversal = true; // bool | Return reversal transaciton and its parent or not

try {
    $result = $apiInstance->getAllTransactions($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getAllTransactions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **store** | [**int[]**](../Model/int.md)| Id of Store to query | [optional]
 **clerk** | [**int[]**](../Model/int.md)| Id of clerk to query | [optional]
 **customer** | **int**| Id of customer to query | [optional]
 **startTime** | **\DateTime**| Start datetime eg 2015-07-07T14:43:00+00:00 | [optional]
 **endTime** | **\DateTime**| End datetime eg 2015-07-07T14:43:00+00:00 | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **isBasic** | **bool**| Return detail or not | [optional]
 **cardPan** | **string**| CardPan of Transactions to query | [optional]
 **localTransactionId** | **string**| localTransactionId of transactions to query | [optional]
 **includeReversal** | **bool**| Return reversal transaciton and its parent or not | [optional]

### Return type

[**\SmartVolution\Model\Transaction[]**](../Model/Transaction.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllTransactionsV2**
> \SmartVolution\Model\Transaction[] getAllTransactionsV2($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal)

Gets a list of all the transactions for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$store = array(56); // int[] | Id of Store to query
$clerk = array(56); // int[] | Id of clerk to query
$customer = 789; // int | Id of customer to query
$startTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Start datetime eg 2015-07-07T14:43:00+00:00
$endTime = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | End datetime eg 2015-07-07T14:43:00+00:00
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$isBasic = true; // bool | Return detail or not
$cardPan = "cardPan_example"; // string | CardPan of Transactions to query
$localTransactionId = "localTransactionId_example"; // string | localTransactionId of transactions to query
$includeReversal = true; // bool | Return reversal transaciton and its parent or not

try {
    $result = $apiInstance->getAllTransactionsV2($tenant, $store, $clerk, $customer, $startTime, $endTime, $since, $deleted, $isBasic, $cardPan, $localTransactionId, $includeReversal);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getAllTransactionsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **store** | [**int[]**](../Model/int.md)| Id of Store to query | [optional]
 **clerk** | [**int[]**](../Model/int.md)| Id of clerk to query | [optional]
 **customer** | **int**| Id of customer to query | [optional]
 **startTime** | **\DateTime**| Start datetime eg 2015-07-07T14:43:00+00:00 | [optional]
 **endTime** | **\DateTime**| End datetime eg 2015-07-07T14:43:00+00:00 | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **isBasic** | **bool**| Return detail or not | [optional]
 **cardPan** | **string**| CardPan of Transactions to query | [optional]
 **localTransactionId** | **string**| localTransactionId of transactions to query | [optional]
 **includeReversal** | **bool**| Return reversal transaciton and its parent or not | [optional]

### Return type

[**\SmartVolution\Model\Transaction[]**](../Model/Transaction.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSuspendedClerks**
> int[] getSuspendedClerks()

Gets a list of clerks that contains suspended transactions

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getSuspendedClerks();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getSuspendedClerks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**int[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSuspendedReasons**
> int[] getSuspendedReasons()

Gets a list of used reasons that contains suspended transactions

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getSuspendedReasons();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getSuspendedReasons: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

**int[]**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTextsRemainingNotification**
> \SmartVolution\Model\ClientNotification getTextsRemainingNotification()

Gets texts remaining notification when the texts remaining lower than text re-order limit

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getTextsRemainingNotification();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->getTextsRemainingNotification: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\ClientNotification**](../Model/ClientNotification.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSuspendedTransaction**
> int putSuspendedTransaction($suspendedTransaction)

Put a suspended transaction in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$suspendedTransaction = new \SmartVolution\Model\SuspendedTransactionInPut(); // \SmartVolution\Model\SuspendedTransactionInPut | Transaction object that need to be created

try {
    $result = $apiInstance->putSuspendedTransaction($suspendedTransaction);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->putSuspendedTransaction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **suspendedTransaction** | [**\SmartVolution\Model\SuspendedTransactionInPut**](../Model/SuspendedTransactionInPut.md)| Transaction object that need to be created |

### Return type

**int**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateTransaction**
> updateTransaction($transaction)

Edit an existing transaction in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1transactionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$transaction = new \SmartVolution\Model\TransactionInEdit(); // \SmartVolution\Model\TransactionInEdit | Transaction object containing edited fields

try {
    $apiInstance->updateTransaction($transaction);
} catch (Exception $e) {
    echo 'Exception when calling V1transactionsApi->updateTransaction: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **transaction** | [**\SmartVolution\Model\TransactionInEdit**](../Model/TransactionInEdit.md)| Transaction object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

