# SmartVolution\V1productsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createProduct**](V1productsApi.md#createProduct) | **POST** /v1/products | Create a new product in the system
[**createProductV2**](V1productsApi.md#createProductV2) | **POST** /v2/products | Create a new product in the system
[**createProductV3**](V1productsApi.md#createProductV3) | **POST** /v3/products | Create a new product in the system
[**createProductV4**](V1productsApi.md#createProductV4) | **POST** /v4/products | Create a new product in the system
[**deleteProductById**](V1productsApi.md#deleteProductById) | **DELETE** /v1/products/{id} | Deletes a product by their id
[**findProductModifierProductById**](V1productsApi.md#findProductModifierProductById) | **GET** /v1/products/productModifierProducts/{id} | Gets ProductModifierProduct details by their id
[**getAllProductModifierProduct**](V1productsApi.md#getAllProductModifierProduct) | **GET** /v1/products/productModifierProducts | Gets a list of all the clerks for a tenant
[**getAllProductPriceLists**](V1productsApi.md#getAllProductPriceLists) | **GET** /v1/products/priceList | Gets a list of all the price lists for a tenant
[**getAllProducts**](V1productsApi.md#getAllProducts) | **GET** /v1/products | Gets a list of all the products for a tenant
[**getAllProductsV2**](V1productsApi.md#getAllProductsV2) | **GET** /v2/products | Gets a list of all the products for a tenant
[**getAllProductsV3**](V1productsApi.md#getAllProductsV3) | **GET** /v3/products | Gets a list of all the products for a tenant
[**getAllProductsV4**](V1productsApi.md#getAllProductsV4) | **GET** /v4/products | Gets a list of all the products for a tenant
[**getAllProductsV5**](V1productsApi.md#getAllProductsV5) | **GET** /v5/products | Gets a list of all the products for a tenant
[**getImageForProduct**](V1productsApi.md#getImageForProduct) | **GET** /v1/products/image | Gets the image for a product
[**getProductTypes**](V1productsApi.md#getProductTypes) | **GET** /v1/products/types | Lists the available options for setting product type
[**getProductbyId**](V1productsApi.md#getProductbyId) | **GET** /v1/products/{id} | Gets product details by their id
[**getProductbyIdV2**](V1productsApi.md#getProductbyIdV2) | **GET** /v2/products/{id} | Gets product details by their id
[**getProductbyIdV3**](V1productsApi.md#getProductbyIdV3) | **GET** /v3/products/{id} | Gets product details by their id
[**getProductbyIdV4**](V1productsApi.md#getProductbyIdV4) | **GET** /v4/products/{id} | Gets product details by their id
[**getProductsWithSearch**](V1productsApi.md#getProductsWithSearch) | **GET** /v1/products/search | Gets a list of all the products for a tenant searching on name and description
[**putProduct**](V1productsApi.md#putProduct) | **PUT** /v1/products | performs an &#39;update or insert&#39; of a product based on its SKU
[**putProductV2**](V1productsApi.md#putProductV2) | **PUT** /v2/products | performs an &#39;update or insert&#39; of a product based on its SKU
[**putProductV3**](V1productsApi.md#putProductV3) | **PUT** /v3/products | performs an &#39;update or insert&#39; of a product based on its SKU
[**putProductV4**](V1productsApi.md#putProductV4) | **PUT** /v4/products | performs an &#39;update or insert&#39; of a product based on its SKU
[**setImageforProduct**](V1productsApi.md#setImageforProduct) | **POST** /v1/products/image | Set the image for a product
[**updateProduct**](V1productsApi.md#updateProduct) | **PATCH** /v1/products | edit an existing product in the system
[**updateProductV2**](V1productsApi.md#updateProductV2) | **PATCH** /v2/products | edit an existing product in the system
[**updateProductV3**](V1productsApi.md#updateProductV3) | **PATCH** /v3/products | edit an existing product in the system
[**updateProductV4**](V1productsApi.md#updateProductV4) | **PATCH** /v4/products | edit an existing product in the system


# **createProduct**
> createProduct($product)

Create a new product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductIn(); // \SmartVolution\Model\ProductIn | Product object that need to be created

try {
    $apiInstance->createProduct($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->createProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductIn**](../Model/ProductIn.md)| Product object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProductV2**
> createProductV2($product)

Create a new product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInV2(); // \SmartVolution\Model\ProductInV2 | Product object that need to be created

try {
    $apiInstance->createProductV2($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->createProductV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInV2**](../Model/ProductInV2.md)| Product object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProductV3**
> createProductV3($product)

Create a new product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInV2(); // \SmartVolution\Model\ProductInV2 | Product object that need to be created

try {
    $apiInstance->createProductV3($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->createProductV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInV2**](../Model/ProductInV2.md)| Product object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createProductV4**
> createProductV4($product)

Create a new product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInV4(); // \SmartVolution\Model\ProductInV4 | Product object that need to be created

try {
    $apiInstance->createProductV4($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->createProductV4: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInV4**](../Model/ProductInV4.md)| Product object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteProductById**
> deleteProductById($id)

Deletes a product by their id

Non-Destructive in the database (Products are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of product to delete

try {
    $apiInstance->deleteProductById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->deleteProductById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **findProductModifierProductById**
> \SmartVolution\Model\ProductModifierProduct findProductModifierProductById($id)

Gets ProductModifierProduct details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of productModifierProduct to query

try {
    $result = $apiInstance->findProductModifierProductById($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->findProductModifierProductById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of productModifierProduct to query |

### Return type

[**\SmartVolution\Model\ProductModifierProduct**](../Model/ProductModifierProduct.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductModifierProduct**
> \SmartVolution\Model\ProductModifierProduct[] getAllProductModifierProduct($tenant, $since, $deleted)

Gets a list of all the clerks for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | deleted

try {
    $result = $apiInstance->getAllProductModifierProduct($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductModifierProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductModifierProduct[]**](../Model/ProductModifierProduct.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductPriceLists**
> \SmartVolution\Model\ProductPriceList[] getAllProductPriceLists($tenant, $since, $deleted)

Gets a list of all the price lists for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllProductPriceLists($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductPriceLists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\ProductPriceList[]**](../Model/ProductPriceList.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProducts**
> \SmartVolution\Model\Product[] getAllProducts($tenant, $since, $deleted, $department)

Gets a list of all the products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$department = 789; // int | optional department filter

try {
    $result = $apiInstance->getAllProducts($tenant, $since, $deleted, $department);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **department** | **int**| optional department filter | [optional]

### Return type

[**\SmartVolution\Model\Product[]**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductsV2**
> \SmartVolution\Model\Product[] getAllProductsV2($tenant, $since, $deleted, $department, $basic, $stock)

Gets a list of all the products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$department = 789; // int | optional department filter, only for user
$basic = true; // bool | only show basic value, only for user
$stock = true; // bool | need show stock value or not, only for user

try {
    $result = $apiInstance->getAllProductsV2($tenant, $since, $deleted, $department, $basic, $stock);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **department** | **int**| optional department filter, only for user | [optional]
 **basic** | **bool**| only show basic value, only for user | [optional]
 **stock** | **bool**| need show stock value or not, only for user | [optional]

### Return type

[**\SmartVolution\Model\Product[]**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductsV3**
> \SmartVolution\Model\ProductViii[] getAllProductsV3($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search)

Gets a list of all the products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$department = 789; // int | optional department filter, only for user
$supplier = 789; // int | optional supplier filter, only for user
$basic = true; // bool | only show basic value, only for user
$stock = true; // bool | need show stock value or not, only for user
$search = "search_example"; // string | search term to locate

try {
    $result = $apiInstance->getAllProductsV3($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductsV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **department** | **int**| optional department filter, only for user | [optional]
 **supplier** | **int**| optional supplier filter, only for user | [optional]
 **basic** | **bool**| only show basic value, only for user | [optional]
 **stock** | **bool**| need show stock value or not, only for user | [optional]
 **search** | **string**| search term to locate | [optional]

### Return type

[**\SmartVolution\Model\ProductViii[]**](../Model/ProductViii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductsV4**
> \SmartVolution\Model\ProductViii[] getAllProductsV4($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search)

Gets a list of all the products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$department = 789; // int | optional department filter, only for user
$supplier = 789; // int | optional supplier filter, only for user
$basic = true; // bool | only show basic value, only for user
$stock = true; // bool | need show stock value or not, only for user
$search = "search_example"; // string | search term to locate

try {
    $result = $apiInstance->getAllProductsV4($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductsV4: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **department** | **int**| optional department filter, only for user | [optional]
 **supplier** | **int**| optional supplier filter, only for user | [optional]
 **basic** | **bool**| only show basic value, only for user | [optional]
 **stock** | **bool**| need show stock value or not, only for user | [optional]
 **search** | **string**| search term to locate | [optional]

### Return type

[**\SmartVolution\Model\ProductViii[]**](../Model/ProductViii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllProductsV5**
> \SmartVolution\Model\ProductVv[] getAllProductsV5($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search, $surchargeProduct, $includeModifierProduct)

Gets a list of all the products for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted
$department = 789; // int | optional department filter, only for user
$supplier = 789; // int | optional supplier filter, only for user
$basic = true; // bool | only show basic value, only for user
$stock = true; // bool | need show stock value or not, only for user
$search = "search_example"; // string | search term to locate
$surchargeProduct = true; // bool | only show surcharge products
$includeModifierProduct = true; // bool | 

try {
    $result = $apiInstance->getAllProductsV5($tenant, $since, $deleted, $department, $supplier, $basic, $stock, $search, $surchargeProduct, $includeModifierProduct);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getAllProductsV5: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]
 **department** | **int**| optional department filter, only for user | [optional]
 **supplier** | **int**| optional supplier filter, only for user | [optional]
 **basic** | **bool**| only show basic value, only for user | [optional]
 **stock** | **bool**| need show stock value or not, only for user | [optional]
 **search** | **string**| search term to locate | [optional]
 **surchargeProduct** | **bool**| only show surcharge products | [optional]
 **includeModifierProduct** | **bool**|  | [optional]

### Return type

[**\SmartVolution\Model\ProductVv[]**](../Model/ProductVv.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getImageForProduct**
> \SmartVolution\Model\ProductWithImageOut getImageForProduct($id, $json)

Gets the image for a product

returns the image for the product or a json object

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Product to query
$json = true; // bool | Set if you wish to receieve the image as base64 encoded text in JSON

try {
    $result = $apiInstance->getImageForProduct($id, $json);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getImageForProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Product to query |
 **json** | **bool**| Set if you wish to receieve the image as base64 encoded text in JSON | [optional]

### Return type

[**\SmartVolution\Model\ProductWithImageOut**](../Model/ProductWithImageOut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductTypes**
> getProductTypes()

Lists the available options for setting product type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $apiInstance->getProductTypes();
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductbyId**
> \SmartVolution\Model\Product getProductbyId($id)

Gets product details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of product to query

try {
    $result = $apiInstance->getProductbyId($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductbyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to query |

### Return type

[**\SmartVolution\Model\Product**](../Model/Product.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductbyIdV2**
> \SmartVolution\Model\ProductWithTaxDeptV2 getProductbyIdV2($id)

Gets product details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of product to query

try {
    $result = $apiInstance->getProductbyIdV2($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductbyIdV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to query |

### Return type

[**\SmartVolution\Model\ProductWithTaxDeptV2**](../Model/ProductWithTaxDeptV2.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductbyIdV3**
> \SmartVolution\Model\ProductWithTaxDeptV2 getProductbyIdV3($id)

Gets product details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of product to query

try {
    $result = $apiInstance->getProductbyIdV3($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductbyIdV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to query |

### Return type

[**\SmartVolution\Model\ProductWithTaxDeptV2**](../Model/ProductWithTaxDeptV2.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductbyIdV4**
> \SmartVolution\Model\ProductWithTaxDeptV2 getProductbyIdV4($id)

Gets product details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of product to query

try {
    $result = $apiInstance->getProductbyIdV4($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductbyIdV4: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of product to query |

### Return type

[**\SmartVolution\Model\ProductWithTaxDeptV2**](../Model/ProductWithTaxDeptV2.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProductsWithSearch**
> \SmartVolution\Model\ProductForBrowser[] getProductsWithSearch($search, $tenant, $extendedInfo, $department, $supplier, $ignoreDept, $ignoreDisabled, $ignoreContainer, $ignoreFixedMeasure, $productType, $forProductModifierProduct)

Gets a list of all the products for a tenant searching on name and description

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = "search_example"; // string | search term to locate
$tenant = 789; // int | Id of Tenant to query
$extendedInfo = true; // bool | return additional product info
$department = 789; // int | optional department filter
$supplier = 789; // int | optional supplier filter
$ignoreDept = true; // bool | ignore dept product info or not
$ignoreDisabled = true; // bool | ignore disalbed product info or not
$ignoreContainer = true; // bool | ignore container product info or not.
$ignoreFixedMeasure = true; // bool | ignore fixed measure product info or not.
$productType = "productType_example"; // string | search product for type.
$forProductModifierProduct = true; // bool | search for productModifierProduct.

try {
    $result = $apiInstance->getProductsWithSearch($search, $tenant, $extendedInfo, $department, $supplier, $ignoreDept, $ignoreDisabled, $ignoreContainer, $ignoreFixedMeasure, $productType, $forProductModifierProduct);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->getProductsWithSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| search term to locate |
 **tenant** | **int**| Id of Tenant to query | [optional]
 **extendedInfo** | **bool**| return additional product info | [optional]
 **department** | **int**| optional department filter | [optional]
 **supplier** | **int**| optional supplier filter | [optional]
 **ignoreDept** | **bool**| ignore dept product info or not | [optional]
 **ignoreDisabled** | **bool**| ignore disalbed product info or not | [optional]
 **ignoreContainer** | **bool**| ignore container product info or not. | [optional]
 **ignoreFixedMeasure** | **bool**| ignore fixed measure product info or not. | [optional]
 **productType** | **string**| search product for type. | [optional]
 **forProductModifierProduct** | **bool**| search for productModifierProduct. | [optional]

### Return type

[**\SmartVolution\Model\ProductForBrowser[]**](../Model/ProductForBrowser.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProduct**
> putProduct($product)

performs an 'update or insert' of a product based on its SKU



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInOver(); // \SmartVolution\Model\ProductInOver | Product object containing edited fields

try {
    $apiInstance->putProduct($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->putProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInOver**](../Model/ProductInOver.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProductV2**
> putProductV2($product)

performs an 'update or insert' of a product based on its SKU



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInOverV2(); // \SmartVolution\Model\ProductInOverV2 | Product object containing edited fields

try {
    $apiInstance->putProductV2($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->putProductV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInOverV2**](../Model/ProductInOverV2.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProductV3**
> putProductV3($product)

performs an 'update or insert' of a product based on its SKU



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInOverV2(); // \SmartVolution\Model\ProductInOverV2 | Product object containing edited fields

try {
    $apiInstance->putProductV3($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->putProductV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInOverV2**](../Model/ProductInOverV2.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putProductV4**
> putProductV4($product)

performs an 'update or insert' of a product based on its SKU



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInOverV4(); // \SmartVolution\Model\ProductInOverV4 | Product object containing edited fields

try {
    $apiInstance->putProductV4($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->putProductV4: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInOverV4**](../Model/ProductInOverV4.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **setImageforProduct**
> setImageforProduct($product)

Set the image for a product



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductWithImage(); // \SmartVolution\Model\ProductWithImage | Product object containing id and the image as a base64 string

try {
    $apiInstance->setImageforProduct($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->setImageforProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductWithImage**](../Model/ProductWithImage.md)| Product object containing id and the image as a base64 string |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProduct**
> updateProduct($product)

edit an existing product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInEdit(); // \SmartVolution\Model\ProductInEdit | Product object containing edited fields

try {
    $apiInstance->updateProduct($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->updateProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInEdit**](../Model/ProductInEdit.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProductV2**
> updateProductV2($product)

edit an existing product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInEditV2(); // \SmartVolution\Model\ProductInEditV2 | Product object containing edited fields

try {
    $apiInstance->updateProductV2($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->updateProductV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInEditV2**](../Model/ProductInEditV2.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProductV3**
> updateProductV3($product)

edit an existing product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInEditV2(); // \SmartVolution\Model\ProductInEditV2 | Product object containing edited fields

try {
    $apiInstance->updateProductV3($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->updateProductV3: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInEditV2**](../Model/ProductInEditV2.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateProductV4**
> updateProductV4($product)

edit an existing product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1productsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$product = new \SmartVolution\Model\ProductInEditV4(); // \SmartVolution\Model\ProductInEditV4 | Product object containing edited fields

try {
    $apiInstance->updateProductV4($product);
} catch (Exception $e) {
    echo 'Exception when calling V1productsApi->updateProductV4: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\SmartVolution\Model\ProductInEditV4**](../Model/ProductInEditV4.md)| Product object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

