# SmartVolution\V1deviceconfiggroupApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createConfigGroup**](V1deviceconfiggroupApi.md#createConfigGroup) | **POST** /v1/device/config/group | Create a Config Group in the system
[**deleteConfigGroupById**](V1deviceconfiggroupApi.md#deleteConfigGroupById) | **DELETE** /v1/device/config/group/{id} | Deletes a config group by their id
[**getAllConfigGroups**](V1deviceconfiggroupApi.md#getAllConfigGroups) | **GET** /v1/device/config/group | Gets a list of all the ConfigGroups
[**updateConfigGroup**](V1deviceconfiggroupApi.md#updateConfigGroup) | **PATCH** /v1/device/config/group | edit an existing config group in the system


# **createConfigGroup**
> createConfigGroup($configGroup)

Create a Config Group in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfiggroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$configGroup = new \SmartVolution\Model\ConfigGroupIn(); // \SmartVolution\Model\ConfigGroupIn | Config Group object that need to be created

try {
    $apiInstance->createConfigGroup($configGroup);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfiggroupApi->createConfigGroup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configGroup** | [**\SmartVolution\Model\ConfigGroupIn**](../Model/ConfigGroupIn.md)| Config Group object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConfigGroupById**
> deleteConfigGroupById($id)

Deletes a config group by their id

Destructive in the database

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfiggroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of config group to delete

try {
    $apiInstance->deleteConfigGroupById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfiggroupApi->deleteConfigGroupById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of config group to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllConfigGroups**
> \SmartVolution\Model\ConfigGroup[] getAllConfigGroups()

Gets a list of all the ConfigGroups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfiggroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->getAllConfigGroups();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfiggroupApi->getAllConfigGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\SmartVolution\Model\ConfigGroup[]**](../Model/ConfigGroup.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateConfigGroup**
> updateConfigGroup($configGroup)

edit an existing config group in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1deviceconfiggroupApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$configGroup = new \SmartVolution\Model\ConfigGroupInEdit(); // \SmartVolution\Model\ConfigGroupInEdit | Config Group object containing edited fields

try {
    $apiInstance->updateConfigGroup($configGroup);
} catch (Exception $e) {
    echo 'Exception when calling V1deviceconfiggroupApi->updateConfigGroup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **configGroup** | [**\SmartVolution\Model\ConfigGroupInEdit**](../Model/ConfigGroupInEdit.md)| Config Group object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

