# SmartVolution\V1customerProductsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createCustomerProduct**](V1customerProductsApi.md#createCustomerProduct) | **POST** /v1/customerProducts | Create a customer product in the system
[**deleteCustomerProductById**](V1customerProductsApi.md#deleteCustomerProductById) | **DELETE** /V1/customerProducts/{id} | Deletes a customer product by their id
[**getAllCustomerProducts**](V1customerProductsApi.md#getAllCustomerProducts) | **GET** /v1/customerProducts | Gets a list of all the Customer Product for a tenant
[**updateCustomerProduct**](V1customerProductsApi.md#updateCustomerProduct) | **PATCH** /v1/customerProducts | Edit an existing customer product in the system


# **createCustomerProduct**
> createCustomerProduct($customerProduct)

Create a customer product in the system

This is not finalised as there is no authentication

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customerProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerProduct = new \SmartVolution\Model\CustomerProductIn(); // \SmartVolution\Model\CustomerProductIn | CustomerProduct object that need to be created

try {
    $apiInstance->createCustomerProduct($customerProduct);
} catch (Exception $e) {
    echo 'Exception when calling V1customerProductsApi->createCustomerProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerProduct** | [**\SmartVolution\Model\CustomerProductIn**](../Model/CustomerProductIn.md)| CustomerProduct object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCustomerProductById**
> deleteCustomerProductById($id)

Deletes a customer product by their id

Non-Destructive in the database (CustomerProduct are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customerProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Customer Field to delete

try {
    $apiInstance->deleteCustomerProductById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1customerProductsApi->deleteCustomerProductById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Customer Field to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllCustomerProducts**
> \SmartVolution\Model\CustomerProduct[] getAllCustomerProducts($customerId, $productId, $listId, $since, $deleted)

Gets a list of all the Customer Product for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customerProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerId = 789; // int | Id of customer to query
$productId = 789; // int | Id of product to query
$listId = 789; // int | ListId to query
$since = 789; // int | A time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllCustomerProducts($customerId, $productId, $listId, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1customerProductsApi->getAllCustomerProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerId** | **int**| Id of customer to query | [optional]
 **productId** | **int**| Id of product to query | [optional]
 **listId** | **int**| ListId to query | [optional]
 **since** | **int**| A time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\CustomerProduct[]**](../Model/CustomerProduct.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateCustomerProduct**
> updateCustomerProduct($customerProductInEdit)

Edit an existing customer product in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1customerProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$customerProductInEdit = new \SmartVolution\Model\CustomerProductInEdit(); // \SmartVolution\Model\CustomerProductInEdit | Customer field object containing edited fields

try {
    $apiInstance->updateCustomerProduct($customerProductInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1customerProductsApi->updateCustomerProduct: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customerProductInEdit** | [**\SmartVolution\Model\CustomerProductInEdit**](../Model/CustomerProductInEdit.md)| Customer field object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

