# SmartVolution\V1storesApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createStore**](V1storesApi.md#createStore) | **POST** /v1/stores | Create a new store in the system
[**createStoreV2**](V1storesApi.md#createStoreV2) | **POST** /v2/stores | Create a new store in the system
[**deleteStoreById**](V1storesApi.md#deleteStoreById) | **DELETE** /v1/stores/{id} | Deletes a store by their id
[**getAllStorePriceLists**](V1storesApi.md#getAllStorePriceLists) | **GET** /V1/stores/priceLists | Gets a list of all the price lists for a tenant
[**getAllStorePriceListsV2**](V1storesApi.md#getAllStorePriceListsV2) | **GET** /V2/stores/priceLists | Gets a list of all the price lists for a tenant
[**getAllStores**](V1storesApi.md#getAllStores) | **GET** /v1/stores | Gets a list of all the stores for a tenant
[**getStorebyId**](V1storesApi.md#getStorebyId) | **GET** /v1/stores/{id} | Gets store details by their id
[**getStorebyIdV2**](V1storesApi.md#getStorebyIdV2) | **GET** /v2/stores/{id} | Gets store details by their id
[**getStoresWithSearch**](V1storesApi.md#getStoresWithSearch) | **GET** /v1/stores/search | Gets a list of all the stores for a tenant searching on name and description
[**updateStore**](V1storesApi.md#updateStore) | **PATCH** /v1/stores | edit an existing store in the system
[**updateStoreV2**](V1storesApi.md#updateStoreV2) | **PATCH** /v2/stores | edit an existing store in the system


# **createStore**
> createStore($store)

Create a new store in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store = new \SmartVolution\Model\StoreIn(); // \SmartVolution\Model\StoreIn | Store object that need to be created

try {
    $apiInstance->createStore($store);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->createStore: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store** | [**\SmartVolution\Model\StoreIn**](../Model/StoreIn.md)| Store object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **createStoreV2**
> createStoreV2($store)

Create a new store in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store = new \SmartVolution\Model\StoreV2In(); // \SmartVolution\Model\StoreV2In | Store object that need to be created

try {
    $apiInstance->createStoreV2($store);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->createStoreV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store** | [**\SmartVolution\Model\StoreV2In**](../Model/StoreV2In.md)| Store object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteStoreById**
> deleteStoreById($id)

Deletes a store by their id

Non-Destructive in the database (Stores are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of store to delete

try {
    $apiInstance->deleteStoreById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->deleteStoreById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of store to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllStorePriceLists**
> \SmartVolution\Model\StorePriceLists[] getAllStorePriceLists($tenant, $since, $deleted)

Gets a list of all the price lists for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllStorePriceLists($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getAllStorePriceLists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\StorePriceLists[]**](../Model/StorePriceLists.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllStorePriceListsV2**
> \SmartVolution\Model\StorePriceListsVii[] getAllStorePriceListsV2($tenant, $since, $deleted)

Gets a list of all the price lists for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllStorePriceListsV2($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getAllStorePriceListsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\StorePriceListsVii[]**](../Model/StorePriceListsVii.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllStores**
> \SmartVolution\Model\Store[] getAllStores($tenant, $since, $deleted)

Gets a list of all the stores for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllStores($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getAllStores: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\Store[]**](../Model/Store.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStorebyId**
> \SmartVolution\Model\Store getStorebyId($id)

Gets store details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of store to query

try {
    $result = $apiInstance->getStorebyId($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getStorebyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of store to query |

### Return type

[**\SmartVolution\Model\Store**](../Model/Store.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStorebyIdV2**
> \SmartVolution\Model\StoreWithPriceListsV2 getStorebyIdV2($id)

Gets store details by their id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of store to query

try {
    $result = $apiInstance->getStorebyIdV2($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getStorebyIdV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of store to query |

### Return type

[**\SmartVolution\Model\StoreWithPriceListsV2**](../Model/StoreWithPriceListsV2.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getStoresWithSearch**
> \SmartVolution\Model\Department[] getStoresWithSearch($search, $tenant)

Gets a list of all the stores for a tenant searching on name and description

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = "search_example"; // string | search term to locate
$tenant = 789; // int | Id of Tenant to query

try {
    $result = $apiInstance->getStoresWithSearch($search, $tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->getStoresWithSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| search term to locate |
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\Department[]**](../Model/Department.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateStore**
> updateStore($store)

edit an existing store in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store = new \SmartVolution\Model\StoreInEdit(); // \SmartVolution\Model\StoreInEdit | Store object containing edited fields

try {
    $apiInstance->updateStore($store);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->updateStore: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store** | [**\SmartVolution\Model\StoreInEdit**](../Model/StoreInEdit.md)| Store object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateStoreV2**
> updateStoreV2($store)

edit an existing store in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1storesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$store = new \SmartVolution\Model\StoreV2InEdit(); // \SmartVolution\Model\StoreV2InEdit | Store object containing edited fields

try {
    $apiInstance->updateStoreV2($store);
} catch (Exception $e) {
    echo 'Exception when calling V1storesApi->updateStoreV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **store** | [**\SmartVolution\Model\StoreV2InEdit**](../Model/StoreV2InEdit.md)| Store object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

