# SmartVolution\V1departmentsApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**createDepartment**](V1departmentsApi.md#createDepartment) | **POST** /v1/departments | Create a new department in the system
[**deleteDepartmentById**](V1departmentsApi.md#deleteDepartmentById) | **DELETE** /v1/departments/{id} | Deletes a department by its id
[**getAllDepartments**](V1departmentsApi.md#getAllDepartments) | **GET** /v1/departments | Gets a list of all the departments for a tenant
[**getAllDepartmentsV2**](V1departmentsApi.md#getAllDepartmentsV2) | **GET** /v2/departments | Gets a list of all the departments for a tenant
[**getDepartmentbyId**](V1departmentsApi.md#getDepartmentbyId) | **GET** /v1/departments/{id} | Gets department details by id
[**getDepartmentsWithSearch**](V1departmentsApi.md#getDepartmentsWithSearch) | **GET** /v1/departments/search | Gets a list of all the departments for a tenant searching on name and description
[**getImageForDepartment**](V1departmentsApi.md#getImageForDepartment) | **GET** /v1/departments/image | Gets the image for a department
[**putDepartment**](V1departmentsApi.md#putDepartment) | **PUT** /v1/departments | performs an &#39;update or insert&#39; of a Department based on its Department Code
[**updateDepartment**](V1departmentsApi.md#updateDepartment) | **PATCH** /v1/departments | edit an existing department in the system


# **createDepartment**
> createDepartment($department)

Create a new department in the system

This is not finalised as there is no security

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$department = new \SmartVolution\Model\DepartmentIn(); // \SmartVolution\Model\DepartmentIn | Department object that need to be created

try {
    $apiInstance->createDepartment($department);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->createDepartment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **department** | [**\SmartVolution\Model\DepartmentIn**](../Model/DepartmentIn.md)| Department object that need to be created |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteDepartmentById**
> deleteDepartmentById($id)

Deletes a department by its id

Non-Destructive in the database (depts are flagged as deleted)

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of department to delete

try {
    $apiInstance->deleteDepartmentById($id);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->deleteDepartmentById: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of department to delete |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllDepartments**
> \SmartVolution\Model\Department[] getAllDepartments($tenant, $since, $deleted)

Gets a list of all the departments for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllDepartments($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->getAllDepartments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\Department[]**](../Model/Department.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAllDepartmentsV2**
> \SmartVolution\Model\Department[] getAllDepartmentsV2($tenant, $since, $deleted)

Gets a list of all the departments for a tenant

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$tenant = 789; // int | Id of Tenant to query
$since = 789; // int | a time in seconds since midnight January 1st 1970 UTC
$deleted = true; // bool | Shows only records that have been deleted

try {
    $result = $apiInstance->getAllDepartmentsV2($tenant, $since, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->getAllDepartmentsV2: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tenant** | **int**| Id of Tenant to query | [optional]
 **since** | **int**| a time in seconds since midnight January 1st 1970 UTC | [optional]
 **deleted** | **bool**| Shows only records that have been deleted | [optional]

### Return type

[**\SmartVolution\Model\Department[]**](../Model/Department.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDepartmentbyId**
> \SmartVolution\Model\Department getDepartmentbyId($id)

Gets department details by id

Authenticated Devices do not have access to this call

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of department to query

try {
    $result = $apiInstance->getDepartmentbyId($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->getDepartmentbyId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of department to query |

### Return type

[**\SmartVolution\Model\Department**](../Model/Department.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDepartmentsWithSearch**
> \SmartVolution\Model\Department[] getDepartmentsWithSearch($search, $tenant)

Gets a list of all the departments for a tenant searching on name and description

if no tenant id is passed then will default to the user/device tenant

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$search = "search_example"; // string | search term to locate
$tenant = 789; // int | Id of Tenant to query

try {
    $result = $apiInstance->getDepartmentsWithSearch($search, $tenant);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->getDepartmentsWithSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **search** | **string**| search term to locate |
 **tenant** | **int**| Id of Tenant to query | [optional]

### Return type

[**\SmartVolution\Model\Department[]**](../Model/Department.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getImageForDepartment**
> getImageForDepartment($id, $json)

Gets the image for a department

returns the image for the department

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 789; // int | Id of Department to query
$json = true; // bool | Set if you wish to receieve the image as base64 encoded text in JSON

try {
    $apiInstance->getImageForDepartment($id, $json);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->getImageForDepartment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**| Id of Department to query |
 **json** | **bool**| Set if you wish to receieve the image as base64 encoded text in JSON | [optional]

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putDepartment**
> \SmartVolution\Model\DepartmentPut[] putDepartment($department)

performs an 'update or insert' of a Department based on its Department Code



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$department = new \SmartVolution\Model\DepartmentPut(); // \SmartVolution\Model\DepartmentPut | Department object containing edited fields

try {
    $result = $apiInstance->putDepartment($department);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->putDepartment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **department** | [**\SmartVolution\Model\DepartmentPut**](../Model/DepartmentPut.md)| Department object containing edited fields |

### Return type

[**\SmartVolution\Model\DepartmentPut[]**](../Model/DepartmentPut.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **updateDepartment**
> updateDepartment($departmentInEdit)

edit an existing department in the system

use parent: -1 to clear

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1departmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$departmentInEdit = new \SmartVolution\Model\DepartmentInEdit(); // \SmartVolution\Model\DepartmentInEdit | Department object containing edited fields

try {
    $apiInstance->updateDepartment($departmentInEdit);
} catch (Exception $e) {
    echo 'Exception when calling V1departmentsApi->updateDepartment: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **departmentInEdit** | [**\SmartVolution\Model\DepartmentInEdit**](../Model/DepartmentInEdit.md)| Department object containing edited fields |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

