# SmartVolution\V1authApi

All URIs are relative to *http://dev.smartvolution.com:9003*

Method | HTTP request | Description
------------- | ------------- | -------------
[**authenticate**](V1authApi.md#authenticate) | **GET** /v1/auth | Authenticates a user against the system


# **authenticate**
> string authenticate($username, $password)

Authenticates a user against the system

Users differ from devices in terms of the data they can access and modify

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new SmartVolution\Api\V1authApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$username = "username_example"; // string | Username of the user attempting authentication
$password = "password_example"; // string | Password of the user attempting authentication

try {
    $result = $apiInstance->authenticate($username, $password);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling V1authApi->authenticate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **username** | **string**| Username of the user attempting authentication |
 **password** | **string**| Password of the user attempting authentication |

### Return type

**string**

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

