<?php

/*
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Talisman\SkuvaultBundle\Skuvault;

use SkuVault;
use Psr\Log\LoggerInterface;

class Service {

    protected $skuVault;
    protected $username;
    protected $password;
    protected $userToken;
    protected $tenantToken;
    protected $logger;
    protected $remote;
    protected $warehouses;

    public function __construct(LoggerInterface $logger, $username, $password, $tenantTodken, $userToken) {

        $this->logger = $logger;
        $this->username = $username;
        $this->password = $password;
        $this->tenantToken = $tenantTodken;
        $this->userToken = $userToken;

        $this->remote = new SkuVault\Remote($logger);
    }

    public function getTenantToken() {
        return $this->tenantToken;
    }

    public function getUserToken() {
        return $this->userToken;
    }

    /**
     * Get the Integrations (accounts)
     * @return json
     */
    public function getIntegrations() {

        $data = [
            'TenantToken' => $this->tenantToken,
            'UserToken' => $this->userToken
        ];

        return $this->remote->call($data, 'integration/getIntegrations');
    }

    /**
     * Get the Warehouses
     * @param int $pageNo
     * @return json
     */
    public function getWarehouses($pageNo = null) {

        $data = [];
        if (!is_null($pageNo)) {
            $data['pageNo'] = $pageNo;
        }
        $data['TenantToken'] = $this->tenantToken;
        $data['UserToken'] = $this->userToken;

        return $this->remote->call($data, 'inventory/getWarehouses');
    }

    protected function loadWarehouses() {
        $inventory = new \SkuVault\Inventory($this->getTenantToken(), $this->getUserToken(), $this->logger);
        $this->warehouses = $inventory->getWarehouses();
    }

    public function getWarehouseIdByCode($code) {

        if ($this->warehouses === null) {
            $this->loadWarehouses();
        }

        # Get Warehouse code from Stored Id
        $skuvaultWarehouseId = null;
        foreach ($this->warehouses->Warehouses as $warehouse) {
            if ($warehouse->Code == $code) {
                $skuvaultWarehouseId = $warehouse->Id;
                break;
            }
        }
        return $skuvaultWarehouseId;
    }

}
