<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Shopify;

use PHPShopify\Exception\SdkException;
use Shopify\ClientBuilder;
use Symfony\Component\Console\Tests\Logger\ConsoleLoggerTest;

class Examples extends \PHPUnit_Framework_TestCase
{
    // need to set these constants
    const SHOP_URL = '';
    const API_KEY = '';
    const PASSWORD = '';
    const SHARED_SECRET = '';

    public function testGetProducts()
    {
        try {

            // the logger argument should not be null. this is only for testing purposes

            $shopify = ClientBuilder::getClient(
                self::SHOP_URL,
                self::API_KEY,
                self::PASSWORD,
                self::SHARED_SECRET,
                null
            );

            $products = $shopify->Product->get();

        } catch (SdkException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetProductById()
    {
        try {

            // the logger argument should not be null. this is only for testing purposes

            $shopify = ClientBuilder::getClient(
                self::SHOP_URL,
                self::API_KEY,
                self::PASSWORD,
                self::SHARED_SECRET,
                null
            );

            $products = $shopify->Product(648382644271)->get();

        } catch (SdkException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testAddProduct()
    {
        try {

            // the logger argument should not be null. this is only for testing purposes

            $shopify = ClientBuilder::getClient(
                self::SHOP_URL,
                self::API_KEY,
                self::PASSWORD,
                self::SHARED_SECRET,
                null
            );

            $product = array (
                "title" => "Burton Custom Freestyle 152",
                "body_html" => "<strong>Brilliant snowboard!</strong>",
                "vendor" => "Burton",
                "product_type" => "Snowboard",
                "tags" => "Barnes & Noble, John's Fav, &quot;Big Air&quot;"
            );

            $product = $shopify->Product->post($product);

        } catch (SdkException $exception) {

            $error = $exception->getMessage();

        }
    }

    public function testGetCustomers()
    {
        try {

            // the logger argument should not be null. this is only for testing purposes

            $shopify = ClientBuilder::getClient(
                self::SHOP_URL,
                self::API_KEY,
                self::PASSWORD,
                self::SHARED_SECRET,
                null
            );

            $customers = $shopify->Customer->get();

        } catch (SdkException $exception) {

            $error = $exception->getMessage();

        }
    }
}