<?php
/**
 * Copyright Talisman Innovations Ltd. (2018). All rights reserved.
 */

namespace Shopify;

use Psr\Log\LoggerInterface;
use PHPShopify\ShopifySDK;

class ClientBuilder
{
    /**
     * @param string $shopUrl
     * @param string $apiKey
     * @param string $password
     * @param string $sharedSecret
     * @param null|LoggerInterface $logger
     * @return ShopifySDK
     */
    public static function getClient($shopUrl, $apiKey, $password, $sharedSecret, LoggerInterface $logger = null)
    {
        $config = array(
            'ShopUrl' => $shopUrl,
            'ApiKey' => $apiKey,
            'Password' => $password,
            'AccessToken' => $password,
            'SharedSecret' => $sharedSecret,
            'Logger' => $logger
        );

        return ShopifySDK::config($config);

    }
}