<?php

declare(strict_types=1);

namespace SalesforceRestApi\Resources;

use SalesforceRestApi\Client\SalesforceClient;
use SalesforceRestApi\Models\ModelInterface;

class Search
{
    public function __construct(
        private readonly SalesforceClient $client
    ) {
    }

    /**
     * Execute a SOSL search
     *
     * @template T of ModelInterface
     * @param class-string<T>|null $modelClass
     * @return T|array
     */
    public function execute(string $sosl, ?string $modelClass = null): ModelInterface|array
    {
        return $this->client->get('/search', $modelClass, ['q' => $sosl]);
    }

    /**
     * Execute a parameterized search
     *
     * @template T of ModelInterface
     * @param class-string<T>|null $modelClass
     * @return T|array
     */
    public function parameterized(array $parameters, ?string $modelClass = null): ModelInterface|array
    {
        return $this->client->post('/parameterizedSearch', $parameters, $modelClass);
    }
}
