<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a User in Salesforce
 */
class User extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    // Name Fields
    #[SerializedName('Username')]
    public ?string $username = null;

    #[SerializedName('FirstName')]
    public ?string $firstName = null;

    #[SerializedName('LastName')]
    public ?string $lastName = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Alias')]
    public ?string $alias = null;

    // Contact Information
    #[SerializedName('Email')]
    public ?string $email = null;

    #[SerializedName('Phone')]
    public ?string $phone = null;

    #[SerializedName('MobilePhone')]
    public ?string $mobilePhone = null;

    #[SerializedName('Fax')]
    public ?string $fax = null;

    // Professional Information
    #[SerializedName('Title')]
    public ?string $title = null;

    #[SerializedName('Department')]
    public ?string $department = null;

    #[SerializedName('Division')]
    public ?string $division = null;

    #[SerializedName('CompanyName')]
    public ?string $companyName = null;

    #[SerializedName('EmployeeNumber')]
    public ?string $employeeNumber = null;

    // Manager
    #[SerializedName('ManagerId')]
    public ?string $managerId = null;

    // Contact
    #[SerializedName('ContactId')]
    public ?string $contactId = null;

    // Account
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    // Profile and Role
    #[SerializedName('ProfileId')]
    public ?string $profileId = null;

    #[SerializedName('UserRoleId')]
    public ?string $userRoleId = null;

    #[SerializedName('UserType')]
    public ?string $userType = null;

    // License
    #[SerializedName('UserPermissionsSFContentUser')]
    public ?bool $userPermissionsSFContentUser = null;

    #[SerializedName('UserPermissionsMarketingUser')]
    public ?bool $userPermissionsMarketingUser = null;

    #[SerializedName('UserPermissionsOfflineUser')]
    public ?bool $userPermissionsOfflineUser = null;

    #[SerializedName('UserPermissionsCallCenterAutoLogin')]
    public ?bool $userPermissionsCallCenterAutoLogin = null;

    // Status
    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    // Address
    #[SerializedName('Street')]
    public ?string $street = null;

    #[SerializedName('City')]
    public ?string $city = null;

    #[SerializedName('State')]
    public ?string $state = null;

    #[SerializedName('PostalCode')]
    public ?string $postalCode = null;

    #[SerializedName('Country')]
    public ?string $country = null;

    #[SerializedName('Latitude')]
    public ?float $latitude = null;

    #[SerializedName('Longitude')]
    public ?float $longitude = null;

    #[SerializedName('GeocodeAccuracy')]
    public ?string $geocodeAccuracy = null;

    // Locale and Language
    #[SerializedName('TimeZoneSidKey')]
    public ?string $timeZoneSidKey = null;

    #[SerializedName('LocaleSidKey')]
    public ?string $localeSidKey = null;

    #[SerializedName('LanguageLocaleKey')]
    public ?string $languageLocaleKey = null;

    #[SerializedName('EmailEncodingKey')]
    public ?string $emailEncodingKey = null;

    // Email Preferences
    #[SerializedName('EmailPreferencesAutoBcc')]
    public ?bool $emailPreferencesAutoBcc = null;

    #[SerializedName('EmailPreferencesAutoBccStayInTouch')]
    public ?bool $emailPreferencesAutoBccStayInTouch = null;

    #[SerializedName('EmailPreferencesStayInTouchReminder')]
    public ?bool $emailPreferencesStayInTouchReminder = null;

    // Signature
    #[SerializedName('Signature')]
    public ?string $signature = null;

    // Delegates
    #[SerializedName('DelegatedApproverId')]
    public ?string $delegatedApproverId = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Login Information
    #[SerializedName('LastLoginDate')]
    public ?string $lastLoginDate = null;

    #[SerializedName('LastPasswordChangeDate')]
    public ?string $lastPasswordChangeDate = null;

    // Photo
    #[SerializedName('SmallPhotoUrl')]
    public ?string $smallPhotoUrl = null;

    #[SerializedName('FullPhotoUrl')]
    public ?string $fullPhotoUrl = null;

    #[SerializedName('BannerPhotoUrl')]
    public ?string $bannerPhotoUrl = null;

    // About Me
    #[SerializedName('AboutMe')]
    public ?string $aboutMe = null;

    // Community Nickname
    #[SerializedName('CommunityNickname')]
    public ?string $communityNickname = null;
}
