<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Task in Salesforce
 * A task is a to-do item or activity
 */
class Task extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Account and Contact
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    #[SerializedName('WhoId')]
    public ?string $whoId = null; // Contact or Lead ID

    #[SerializedName('WhatId')]
    public ?string $whatId = null; // Related object ID (Account, Opportunity, etc.)

    // Task Information
    #[SerializedName('Subject')]
    public ?string $subject = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('Status')]
    public ?string $status = null;

    #[SerializedName('Priority')]
    public ?string $priority = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    // Dates
    #[SerializedName('ActivityDate')]
    public ?string $activityDate = null;

    #[SerializedName('ReminderDateTime')]
    public ?string $reminderDateTime = null;

    #[SerializedName('IsReminderSet')]
    public ?bool $isReminderSet = null;

    #[SerializedName('CompletedDateTime')]
    public ?string $completedDateTime = null;

    // Recurrence
    #[SerializedName('IsRecurrence')]
    public ?bool $isRecurrence = null;

    #[SerializedName('RecurrenceActivityId')]
    public ?string $recurrenceActivityId = null;

    #[SerializedName('RecurrenceStartDateOnly')]
    public ?string $recurrenceStartDateOnly = null;

    #[SerializedName('RecurrenceEndDateOnly')]
    public ?string $recurrenceEndDateOnly = null;

    #[SerializedName('RecurrenceType')]
    public ?string $recurrenceType = null;

    #[SerializedName('RecurrenceInterval')]
    public ?int $recurrenceInterval = null;

    #[SerializedName('RecurrenceDayOfWeekMask')]
    public ?int $recurrenceDayOfWeekMask = null;

    #[SerializedName('RecurrenceDayOfMonth')]
    public ?int $recurrenceDayOfMonth = null;

    #[SerializedName('RecurrenceInstance')]
    public ?string $recurrenceInstance = null;

    #[SerializedName('RecurrenceMonthOfYear')]
    public ?string $recurrenceMonthOfYear = null;

    #[SerializedName('RecurrenceRegeneratedType')]
    public ?string $recurrenceRegeneratedType = null;

    #[SerializedName('RecurrenceTimeZoneSidKey')]
    public ?string $recurrenceTimeZoneSidKey = null;

    // Call Information
    #[SerializedName('CallDurationInSeconds')]
    public ?int $callDurationInSeconds = null;

    #[SerializedName('CallType')]
    public ?string $callType = null;

    #[SerializedName('CallDisposition')]
    public ?string $callDisposition = null;

    #[SerializedName('CallObject')]
    public ?string $callObject = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Archived
    #[SerializedName('IsArchived')]
    public ?bool $isArchived = null;

    // High Priority
    #[SerializedName('IsHighPriority')]
    public ?bool $isHighPriority = null;

    // Task Subtype
    #[SerializedName('TaskSubtype')]
    public ?string $taskSubtype = null;
}
