<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Purchase Line Item in Salesforce
 * Individual product or service on a purchase
 */
class PurchaseLineItem extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Purchase Association
    #[SerializedName('PurchaseId')]
    public ?string $purchaseId = null;

    // Product Information
    #[SerializedName('Product2Id')]
    public ?string $product2Id = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('ProductCode')]
    public ?string $productCode = null;

    // Quantity and Price
    #[SerializedName('Quantity')]
    public ?float $quantity = null;

    #[SerializedName('UnitPrice')]
    public ?float $unitPrice = null;

    #[SerializedName('ListPrice')]
    public ?float $listPrice = null;

    #[SerializedName('TotalLineAmount')]
    public ?float $totalLineAmount = null;

    #[SerializedName('Discount')]
    public ?float $discount = null;

    #[SerializedName('DiscountPercentage')]
    public ?float $discountPercentage = null;

    // Tax
    #[SerializedName('TaxAmount')]
    public ?float $taxAmount = null;

    #[SerializedName('TaxPercentage')]
    public ?float $taxPercentage = null;

    #[SerializedName('TaxCode')]
    public ?string $taxCode = null;

    // Total
    #[SerializedName('GrandTotalAmount')]
    public ?float $grandTotalAmount = null;

    // Line Number
    #[SerializedName('LineNumber')]
    public ?int $lineNumber = null;

    #[SerializedName('SortOrder')]
    public ?int $sortOrder = null;

    // Status
    #[SerializedName('Status')]
    public ?string $status = null;

    // Dates
    #[SerializedName('ServiceDate')]
    public ?string $serviceDate = null;

    #[SerializedName('DeliveryDate')]
    public ?string $deliveryDate = null;

    // Unit of Measure
    #[SerializedName('UnitOfMeasure')]
    public ?string $unitOfMeasure = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
