<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Purchase in Salesforce
 * A purchase represents a completed transaction
 */
class Purchase extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    // Purchase Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('PurchaseNumber')]
    public ?string $purchaseNumber = null;

    #[SerializedName('Status')]
    public ?string $status = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    // Amounts
    #[SerializedName('TotalAmount')]
    public ?float $totalAmount = null;

    #[SerializedName('TaxAmount')]
    public ?float $taxAmount = null;

    #[SerializedName('GrandTotalAmount')]
    public ?float $grandTotalAmount = null;

    #[SerializedName('AdjustmentAmount')]
    public ?float $adjustmentAmount = null;

    // Dates
    #[SerializedName('PurchaseDate')]
    public ?string $purchaseDate = null;

    #[SerializedName('ExpectedDeliveryDate')]
    public ?string $expectedDeliveryDate = null;

    #[SerializedName('ActualDeliveryDate')]
    public ?string $actualDeliveryDate = null;

    // Account Association
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    // Billing and Shipping
    #[SerializedName('BillingStreet')]
    public ?string $billingStreet = null;

    #[SerializedName('BillingCity')]
    public ?string $billingCity = null;

    #[SerializedName('BillingState')]
    public ?string $billingState = null;

    #[SerializedName('BillingPostalCode')]
    public ?string $billingPostalCode = null;

    #[SerializedName('BillingCountry')]
    public ?string $billingCountry = null;

    #[SerializedName('BillingLatitude')]
    public ?float $billingLatitude = null;

    #[SerializedName('BillingLongitude')]
    public ?float $billingLongitude = null;

    #[SerializedName('BillingGeocodeAccuracy')]
    public ?string $billingGeocodeAccuracy = null;

    #[SerializedName('ShippingStreet')]
    public ?string $shippingStreet = null;

    #[SerializedName('ShippingCity')]
    public ?string $shippingCity = null;

    #[SerializedName('ShippingState')]
    public ?string $shippingState = null;

    #[SerializedName('ShippingPostalCode')]
    public ?string $shippingPostalCode = null;

    #[SerializedName('ShippingCountry')]
    public ?string $shippingCountry = null;

    #[SerializedName('ShippingLatitude')]
    public ?float $shippingLatitude = null;

    #[SerializedName('ShippingLongitude')]
    public ?float $shippingLongitude = null;

    #[SerializedName('ShippingGeocodeAccuracy')]
    public ?string $shippingGeocodeAccuracy = null;

    // Payment Information
    #[SerializedName('PaymentMethod')]
    public ?string $paymentMethod = null;

    #[SerializedName('PaymentStatus')]
    public ?string $paymentStatus = null;

    #[SerializedName('PaymentTerms')]
    public ?string $paymentTerms = null;

    // Tracking
    #[SerializedName('TrackingNumber')]
    public ?string $trackingNumber = null;

    #[SerializedName('Carrier')]
    public ?string $carrier = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;
}
