<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Product in Salesforce
 */
class Product2 extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Product Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('ProductCode')]
    public ?string $productCode = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    // Family
    #[SerializedName('Family')]
    public ?string $family = null;

    // Quantity and Unit
    #[SerializedName('QuantityUnitOfMeasure')]
    public ?string $quantityUnitOfMeasure = null;

    // External Information
    #[SerializedName('ExternalDataSourceId')]
    public ?string $externalDataSourceId = null;

    #[SerializedName('ExternalId')]
    public ?string $externalId = null;

    #[SerializedName('DisplayUrl')]
    public ?string $displayUrl = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Stock Keeping Unit
    #[SerializedName('StockKeepingUnit')]
    public ?string $stockKeepingUnit = null;
}
