<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Pricebook Entry in Salesforce
 * A pricebook entry is the association of a product with a price book and includes the unit price
 */
class PricebookEntry extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Product Name (read-only, references Product2.Name)
    #[SerializedName('Name')]
    public ?string $name = null;

    // Pricebook Association
    #[SerializedName('Pricebook2Id')]
    public ?string $pricebook2Id = null;

    // Product Association
    #[SerializedName('Product2Id')]
    public ?string $product2Id = null;

    // Product Code (read-only, references Product2.ProductCode)
    #[SerializedName('ProductCode')]
    public ?string $productCode = null;

    // Pricing
    #[SerializedName('UnitPrice')]
    public ?float $unitPrice = null;

    #[SerializedName('UseStandardPrice')]
    public ?bool $useStandardPrice = null;

    // Status
    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    #[SerializedName('IsArchived')]
    public ?bool $isArchived = null;

    // Currency (for orgs with multicurrency enabled)
    #[SerializedName('CurrencyIsoCode')]
    public ?string $currencyIsoCode = null;

    // Price Adjustments (B2B/D2C Commerce)
    #[SerializedName('ActivePriceAdjustmentQuantity')]
    public ?int $activePriceAdjustmentQuantity = null;

    // Subscription Management
    #[SerializedName('ProductSellingModelId')]
    public ?string $productSellingModelId = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
