<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Price Book in Salesforce
 */
class Pricebook2 extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Price Book Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    #[SerializedName('IsStandard')]
    public ?bool $isStandard = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;
}
