<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Organization in Salesforce
 * Contains information about your Salesforce organization
 */
class Organization extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    // Basic Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Division')]
    public ?string $division = null;

    #[SerializedName('OrganizationType')]
    public ?string $organizationType = null;

    #[SerializedName('NamespacePrefix')]
    public ?string $namespacePrefix = null;

    #[SerializedName('InstanceName')]
    public ?string $instanceName = null;

    #[SerializedName('IsSandbox')]
    public ?bool $isSandbox = null;

    // Address Information
    #[SerializedName('Street')]
    public ?string $street = null;

    #[SerializedName('City')]
    public ?string $city = null;

    #[SerializedName('State')]
    public ?string $state = null;

    #[SerializedName('PostalCode')]
    public ?string $postalCode = null;

    #[SerializedName('Country')]
    public ?string $country = null;

    #[SerializedName('Latitude')]
    public ?float $latitude = null;

    #[SerializedName('Longitude')]
    public ?float $longitude = null;

    #[SerializedName('GeocodeAccuracy')]
    public ?string $geocodeAccuracy = null;

    // Contact Information
    #[SerializedName('Phone')]
    public ?string $phone = null;

    #[SerializedName('Fax')]
    public ?string $fax = null;

    #[SerializedName('PrimaryContact')]
    public ?string $primaryContact = null;

    // Locale and Language Settings
    #[SerializedName('DefaultLocaleSidKey')]
    public ?string $defaultLocaleSidKey = null;

    #[SerializedName('LanguageLocaleKey')]
    public ?string $languageLocaleKey = null;

    #[SerializedName('TimeZoneSidKey')]
    public ?string $timeZoneSidKey = null;

    // Fiscal Year Settings
    #[SerializedName('FiscalYearStartMonth')]
    public ?int $fiscalYearStartMonth = null;

    #[SerializedName('UsesStartDateAsFiscalYearName')]
    public ?bool $usesStartDateAsFiscalYearName = null;

    // Default Access Settings
    #[SerializedName('DefaultAccountAccess')]
    public ?string $defaultAccountAccess = null;

    #[SerializedName('DefaultContactAccess')]
    public ?string $defaultContactAccess = null;

    #[SerializedName('DefaultOpportunityAccess')]
    public ?string $defaultOpportunityAccess = null;

    #[SerializedName('DefaultLeadAccess')]
    public ?string $defaultLeadAccess = null;

    #[SerializedName('DefaultCaseAccess')]
    public ?string $defaultCaseAccess = null;

    #[SerializedName('DefaultCalendarAccess')]
    public ?string $defaultCalendarAccess = null;

    #[SerializedName('DefaultPricebookAccess')]
    public ?string $defaultPricebookAccess = null;

    #[SerializedName('DefaultCampaignAccess')]
    public ?string $defaultCampaignAccess = null;

    // Compliance Settings
    #[SerializedName('ComplianceBccEmail')]
    public ?string $complianceBccEmail = null;

    #[SerializedName('WebToCaseDefaultOrigin')]
    public ?string $webToCaseDefaultOrigin = null;

    // Usage Metrics
    #[SerializedName('MonthlyPageViewsUsed')]
    public ?int $monthlyPageViewsUsed = null;

    #[SerializedName('MonthlyPageViewsEntitlement')]
    public ?int $monthlyPageViewsEntitlement = null;

    // Trial Information
    #[SerializedName('TrialExpirationDate')]
    public ?string $trialExpirationDate = null;

    // System Information
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
