<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Order Item (Order Product) in Salesforce
 * An order item is a product associated with an order
 */
class OrderItem extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Order Association
    #[SerializedName('OrderId')]
    public ?string $orderId = null;

    // Product Information
    #[SerializedName('Product2Id')]
    public ?string $product2Id = null;

    #[SerializedName('ProductCode')]
    public ?string $productCode = null;

    // Pricebook Entry
    #[SerializedName('PricebookEntryId')]
    public ?string $pricebookEntryId = null;

    // Original Order Item (for change orders)
    #[SerializedName('OriginalOrderItemId')]
    public ?string $originalOrderItemId = null;

    // Quantity and Price
    #[SerializedName('Quantity')]
    public ?float $quantity = null;

    #[SerializedName('UnitPrice')]
    public ?float $unitPrice = null;

    #[SerializedName('ListPrice')]
    public ?float $listPrice = null;

    #[SerializedName('TotalPrice')]
    public ?float $totalPrice = null;

    // Dates
    #[SerializedName('ServiceDate')]
    public ?string $serviceDate = null;

    #[SerializedName('EndDate')]
    public ?string $endDate = null;

    // Description
    #[SerializedName('Description')]
    public ?string $description = null;

    // Order Item Number
    #[SerializedName('OrderItemNumber')]
    public ?string $orderItemNumber = null;

    // Available Quantity
    #[SerializedName('AvailableQuantity')]
    public ?float $availableQuantity = null;

    // Adjusted Line Amounts (Salesforce Order Management / Revenue Cloud)
    #[SerializedName('AdjustedLineAmount')]
    public ?float $adjustedLineAmount = null;

    #[SerializedName('AdjustedLineAmtWithTax')]
    public ?float $adjustedLineAmtWithTax = null;

    // Billing Frequency (Subscription Management)
    #[SerializedName('BillingFrequency2')]
    public ?string $billingFrequency2 = null;

    // Currency (for orgs with multicurrency enabled)
    #[SerializedName('CurrencyIsoCode')]
    public ?string $currencyIsoCode = null;

    // Delivery Estimation
    #[SerializedName('DeliveryEstimationReference')]
    public ?string $deliveryEstimationReference = null;

    #[SerializedName('DeliveryEstimationTimeZone')]
    public ?string $deliveryEstimationTimeZone = null;

    #[SerializedName('EarliestEstimatedDeliveryDate')]
    public ?string $earliestEstimatedDeliveryDate = null;

    #[SerializedName('EarliestEstimatedDeliveryTime')]
    public ?string $earliestEstimatedDeliveryTime = null;

    #[SerializedName('LastEstimatedDeliveryDate')]
    public ?string $lastEstimatedDeliveryDate = null;

    #[SerializedName('LastEstimatedDeliveryTime')]
    public ?string $lastEstimatedDeliveryTime = null;

    // Date and Time Fields (Revenue Cloud)
    #[SerializedName('EndDateTime')]
    public ?string $endDateTime = null;

    #[SerializedName('EndTime')]
    public ?string $endTime = null;

    #[SerializedName('ServiceDateTime')]
    public ?string $serviceDateTime = null;

    #[SerializedName('ServiceTime')]
    public ?string $serviceTime = null;

    #[SerializedName('ServiceEndTimeZone')]
    public ?string $serviceEndTimeZone = null;

    // Pricing Fields
    #[SerializedName('GrossUnitPrice')]
    public ?float $grossUnitPrice = null;

    #[SerializedName('NetUnitPrice')]
    public ?float $netUnitPrice = null;

    #[SerializedName('ReferencePrice')]
    public ?float $referencePrice = null;

    #[SerializedName('ListPriceTotal')]
    public ?float $listPriceTotal = null;

    #[SerializedName('StartingPriceTotal')]
    public ?float $startingPriceTotal = null;

    #[SerializedName('StartingUnitPriceSource')]
    public ?string $startingUnitPriceSource = null;

    #[SerializedName('ProFormaBillingPeriodAmount')]
    public ?float $proFormaBillingPeriodAmount = null;

    // Line and Adjustment Amounts (Order Management / Revenue Cloud)
    #[SerializedName('LineNumber')]
    public ?int $lineNumber = null;

    #[SerializedName('TotalLineAmount')]
    public ?float $totalLineAmount = null;

    #[SerializedName('RoundedLineAmount')]
    public ?float $roundedLineAmount = null;

    #[SerializedName('RoundedLineAmtWithTax')]
    public ?float $roundedLineAmtWithTax = null;

    #[SerializedName('TotalAdjustmentAmount')]
    public ?float $totalAdjustmentAmount = null;

    #[SerializedName('TotalAdjustmentAmtWithTax')]
    public ?float $totalAdjustmentAmtWithTax = null;

    #[SerializedName('TotalAdjustmentTaxAmount')]
    public ?float $totalAdjustmentTaxAmount = null;

    #[SerializedName('TotalLineAdjustmentAmount')]
    public ?float $totalLineAdjustmentAmount = null;

    #[SerializedName('TotalLineAdjustmentAmtWithTax')]
    public ?float $totalLineAdjustmentAmtWithTax = null;

    #[SerializedName('TotalLineAdjustmentTaxAmount')]
    public ?float $totalLineAdjustmentTaxAmount = null;

    #[SerializedName('TotalAdjustmentDistAmount')]
    public ?float $totalAdjustmentDistAmount = null;

    #[SerializedName('TotalAdjustmentDistTaxAmount')]
    public ?float $totalAdjustmentDistTaxAmount = null;

    #[SerializedName('TotalAdjustmentDistAmtWithTax')]
    public ?float $totalAdjustmentDistAmtWithTax = null;

    #[SerializedName('TotalAdjustedLineTaxAmount')]
    public ?float $totalAdjustedLineTaxAmount = null;

    // Tax Fields
    #[SerializedName('TotalLineTaxAmount')]
    public ?float $totalLineTaxAmount = null;

    #[SerializedName('TotalTaxAmount')]
    public ?float $totalTaxAmount = null;

    #[SerializedName('TotalAmtWithTax')]
    public ?float $totalAmtWithTax = null;

    // Subscription Management Fields
    #[SerializedName('PeriodBoundary')]
    public ?string $periodBoundary = null;

    #[SerializedName('PeriodBoundaryDay')]
    public ?int $periodBoundaryDay = null;

    #[SerializedName('PeriodBoundaryStartMonth')]
    public ?string $periodBoundaryStartMonth = null;

    #[SerializedName('PricingTermCount')]
    public ?float $pricingTermCount = null;

    #[SerializedName('PricingTransactionType')]
    public ?string $pricingTransactionType = null;

    // Reference IDs
    #[SerializedName('OrderActionId')]
    public ?string $orderActionId = null;

    #[SerializedName('OrderDeliveryGroupId')]
    public ?string $orderDeliveryGroupId = null;

    #[SerializedName('PriceRevisionPolicyId')]
    public ?string $priceRevisionPolicyId = null;

    #[SerializedName('ProductSellingModelId')]
    public ?string $productSellingModelId = null;

    #[SerializedName('ProrationPolicyId')]
    public ?string $prorationPolicyId = null;

    #[SerializedName('QuoteLineItemId')]
    public ?string $quoteLineItemId = null;

    #[SerializedName('RelatedOrderItemID')]
    public ?string $relatedOrderItemId = null;

    #[SerializedName('TaxTreatmentId')]
    public ?string $taxTreatmentId = null;

    // Type Fields (Order Management / Revenue Cloud)
    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('TypeCode')]
    public ?string $typeCode = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
