<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Order in Salesforce
 * An order is a quote or contract that has been signed and activated
 */
class Order extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Account Association (Customer)
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    // Contract and Opportunity
    #[SerializedName('ContractId')]
    public ?string $contractId = null;

    #[SerializedName('OpportunityId')]
    public ?string $opportunityId = null;

    // Pricebook
    #[SerializedName('Pricebook2Id')]
    public ?string $pricebook2Id = null;

    // Order Information
    #[SerializedName('OrderNumber')]
    public ?string $orderNumber = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('Status')]
    public ?string $status = null;

    #[SerializedName('StatusCode')]
    public ?string $statusCode = null;

    // Dates
    #[SerializedName('EffectiveDate')]
    public ?string $effectiveDate = null;

    #[SerializedName('EndDate')]
    public ?string $endDate = null;

    #[SerializedName('ActivatedDate')]
    public ?string $activatedDate = null;

    #[SerializedName('ActivatedById')]
    public ?string $activatedById = null;

    // Billing
    #[SerializedName('BillingStreet')]
    public ?string $billingStreet = null;

    #[SerializedName('BillingCity')]
    public ?string $billingCity = null;

    #[SerializedName('BillingState')]
    public ?string $billingState = null;

    #[SerializedName('BillingPostalCode')]
    public ?string $billingPostalCode = null;

    #[SerializedName('BillingCountry')]
    public ?string $billingCountry = null;

    #[SerializedName('BillingLatitude')]
    public ?float $billingLatitude = null;

    #[SerializedName('BillingLongitude')]
    public ?float $billingLongitude = null;

    #[SerializedName('BillingGeocodeAccuracy')]
    public ?string $billingGeocodeAccuracy = null;

    // Shipping
    #[SerializedName('ShippingStreet')]
    public ?string $shippingStreet = null;

    #[SerializedName('ShippingCity')]
    public ?string $shippingCity = null;

    #[SerializedName('ShippingState')]
    public ?string $shippingState = null;

    #[SerializedName('ShippingPostalCode')]
    public ?string $shippingPostalCode = null;

    #[SerializedName('ShippingCountry')]
    public ?string $shippingCountry = null;

    #[SerializedName('ShippingLatitude')]
    public ?float $shippingLatitude = null;

    #[SerializedName('ShippingLongitude')]
    public ?float $shippingLongitude = null;

    #[SerializedName('ShippingGeocodeAccuracy')]
    public ?string $shippingGeocodeAccuracy = null;

    // Contact Information
    #[SerializedName('CustomerAuthorizedById')]
    public ?string $customerAuthorizedById = null;

    #[SerializedName('CustomerAuthorizedDate')]
    public ?string $customerAuthorizedDate = null;

    #[SerializedName('CompanyAuthorizedById')]
    public ?string $companyAuthorizedById = null;

    #[SerializedName('CompanyAuthorizedDate')]
    public ?string $companyAuthorizedDate = null;

    #[SerializedName('BillToContactId')]
    public ?string $billToContactId = null;

    #[SerializedName('ShipToContactId')]
    public ?string $shipToContactId = null;

    // Totals
    #[SerializedName('TotalAmount')]
    public ?float $totalAmount = null;

    // Description
    #[SerializedName('Description')]
    public ?string $description = null;

    // Ownership
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Additional Fields
    #[SerializedName('PoNumber')]
    public ?string $poNumber = null;

    #[SerializedName('PoDate')]
    public ?string $poDate = null;

    #[SerializedName('OrderReferenceNumber')]
    public ?string $orderReferenceNumber = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
