<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Opportunity Line Item (Product) in Salesforce
 */
class OpportunityLineItem extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Opportunity Association
    #[SerializedName('OpportunityId')]
    public ?string $opportunityId = null;

    // Product Information
    #[SerializedName('Product2Id')]
    public ?string $product2Id = null;

    #[SerializedName('ProductCode')]
    public ?string $productCode = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    // Pricebook Entry
    #[SerializedName('PricebookEntryId')]
    public ?string $pricebookEntryId = null;

    // Quantity and Price
    #[SerializedName('Quantity')]
    public ?float $quantity = null;

    #[SerializedName('UnitPrice')]
    public ?float $unitPrice = null;

    #[SerializedName('TotalPrice')]
    public ?float $totalPrice = null;

    #[SerializedName('ListPrice')]
    public ?float $listPrice = null;

    #[SerializedName('Discount')]
    public ?float $discount = null;

    // Dates
    #[SerializedName('ServiceDate')]
    public ?string $serviceDate = null;

    // Sort Order
    #[SerializedName('SortOrder')]
    public ?int $sortOrder = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
