<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Opportunity Contact Role in Salesforce
 * Links a Contact to an Opportunity with a specific role
 */
class OpportunityContactRole extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Opportunity and Contact
    #[SerializedName('OpportunityId')]
    public ?string $opportunityId = null;

    #[SerializedName('ContactId')]
    public ?string $contactId = null;

    // Role Information
    #[SerializedName('Role')]
    public ?string $role = null;

    #[SerializedName('IsPrimary')]
    public ?bool $isPrimary = null;

    // System Fields
    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
