<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Opportunity in Salesforce
 * An opportunity is a sale or pending deal
 */
class Opportunity extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Account Association
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    // Opportunity Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('StageName')]
    public ?string $stageName = null;

    #[SerializedName('Amount')]
    public ?float $amount = null;

    #[SerializedName('Probability')]
    public ?int $probability = null;

    #[SerializedName('ExpectedRevenue')]
    public ?float $expectedRevenue = null;

    #[SerializedName('TotalOpportunityQuantity')]
    public ?float $totalOpportunityQuantity = null;

    #[SerializedName('CloseDate')]
    public ?string $closeDate = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('NextStep')]
    public ?string $nextStep = null;

    #[SerializedName('LeadSource')]
    public ?string $leadSource = null;

    #[SerializedName('IsClosed')]
    public ?bool $isClosed = null;

    #[SerializedName('IsWon')]
    public ?bool $isWon = null;

    #[SerializedName('ForecastCategory')]
    public ?string $forecastCategory = null;

    #[SerializedName('ForecastCategoryName')]
    public ?string $forecastCategoryName = null;

    // Campaign
    #[SerializedName('CampaignId')]
    public ?string $campaignId = null;

    // Financial Fields
    #[SerializedName('HasOpportunityLineItem')]
    public ?bool $hasOpportunityLineItem = null;

    // Primary Contact
    #[SerializedName('ContactId')]
    public ?string $contactId = null;

    // Contract
    #[SerializedName('ContractId')]
    public ?string $contractId = null;

    // Pricebook
    #[SerializedName('Pricebook2Id')]
    public ?string $pricebook2Id = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastActivityDate')]
    public ?string $lastActivityDate = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Stage History
    #[SerializedName('LastStageChangeDate')]
    public ?string $lastStageChangeDate = null;

    // Fiscal Period
    #[SerializedName('FiscalQuarter')]
    public ?int $fiscalQuarter = null;

    #[SerializedName('FiscalYear')]
    public ?int $fiscalYear = null;

    #[SerializedName('Fiscal')]
    public ?string $fiscal = null;

    // Partner
    #[SerializedName('HasOpenActivity')]
    public ?bool $hasOpenActivity = null;

    #[SerializedName('HasOverdueTask')]
    public ?bool $hasOverdueTask = null;

    // Sync
    #[SerializedName('LastAmountChangedHistoryId')]
    public ?string $lastAmountChangedHistoryId = null;

    #[SerializedName('LastCloseDateChangedHistoryId')]
    public ?string $lastCloseDateChangedHistoryId = null;

    // Delivery/Installation Status
    #[SerializedName('DeliveryInstallationStatus__c')]
    public ?string $deliveryInstallationStatus = null;

    #[SerializedName('TrackingNumber__c')]
    public ?string $trackingNumber = null;

    #[SerializedName('OrderNumber__c')]
    public ?string $orderNumber = null;

    #[SerializedName('CurrentGenerators__c')]
    public ?string $currentGenerators = null;

    #[SerializedName('MainCompetitors__c')]
    public ?string $mainCompetitors = null;

    // Push Counter
    #[SerializedName('IsPriorityRecord')]
    public ?bool $isPriorityRecord = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
