<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Lead in Salesforce
 * A lead is a prospect or potential sales opportunity
 */
class Lead extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('MasterRecordId')]
    public ?string $masterRecordId = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Name Fields
    #[SerializedName('Salutation')]
    public ?string $salutation = null;

    #[SerializedName('FirstName')]
    public ?string $firstName = null;

    #[SerializedName('LastName')]
    public ?string $lastName = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Suffix')]
    public ?string $suffix = null;

    // Company Information
    #[SerializedName('Company')]
    public ?string $company = null;

    #[SerializedName('Title')]
    public ?string $title = null;

    #[SerializedName('Industry')]
    public ?string $industry = null;

    #[SerializedName('AnnualRevenue')]
    public ?float $annualRevenue = null;

    #[SerializedName('NumberOfEmployees')]
    public ?int $numberOfEmployees = null;

    #[SerializedName('Rating')]
    public ?string $rating = null;

    // Contact Information
    #[SerializedName('Email')]
    public ?string $email = null;

    #[SerializedName('Phone')]
    public ?string $phone = null;

    #[SerializedName('MobilePhone')]
    public ?string $mobilePhone = null;

    #[SerializedName('Fax')]
    public ?string $fax = null;

    #[SerializedName('Website')]
    public ?string $website = null;

    // Address
    #[SerializedName('Street')]
    public ?string $street = null;

    #[SerializedName('City')]
    public ?string $city = null;

    #[SerializedName('State')]
    public ?string $state = null;

    #[SerializedName('PostalCode')]
    public ?string $postalCode = null;

    #[SerializedName('Country')]
    public ?string $country = null;

    #[SerializedName('Latitude')]
    public ?float $latitude = null;

    #[SerializedName('Longitude')]
    public ?float $longitude = null;

    #[SerializedName('GeocodeAccuracy')]
    public ?string $geocodeAccuracy = null;

    // Status and Conversion
    #[SerializedName('Status')]
    public ?string $status = null;

    #[SerializedName('IsConverted')]
    public ?bool $isConverted = null;

    #[SerializedName('ConvertedDate')]
    public ?string $convertedDate = null;

    #[SerializedName('ConvertedAccountId')]
    public ?string $convertedAccountId = null;

    #[SerializedName('ConvertedContactId')]
    public ?string $convertedContactId = null;

    #[SerializedName('ConvertedOpportunityId')]
    public ?string $convertedOpportunityId = null;

    // Lead Source
    #[SerializedName('LeadSource')]
    public ?string $leadSource = null;

    // Description
    #[SerializedName('Description')]
    public ?string $description = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastActivityDate')]
    public ?string $lastActivityDate = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Email Preferences
    #[SerializedName('EmailBouncedReason')]
    public ?string $emailBouncedReason = null;

    #[SerializedName('EmailBouncedDate')]
    public ?string $emailBouncedDate = null;

    #[SerializedName('HasOptedOutOfEmail')]
    public ?bool $hasOptedOutOfEmail = null;

    #[SerializedName('DoNotCall')]
    public ?bool $doNotCall = null;

    #[SerializedName('HasOptedOutOfFax')]
    public ?bool $hasOptedOutOfFax = null;

    // Jigsaw
    #[SerializedName('Jigsaw')]
    public ?string $jigsaw = null;

    #[SerializedName('JigsawContactId')]
    public ?string $jigsawContactId = null;

    // Photo URL
    #[SerializedName('PhotoUrl')]
    public ?string $photoUrl = null;

    // Individual
    #[SerializedName('IndividualId')]
    public ?string $individualId = null;

    // Unread By Owner
    #[SerializedName('IsUnreadByOwner')]
    public ?bool $isUnreadByOwner = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
