<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Event in Salesforce
 * An event is a calendar appointment
 */
class Event extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Account and Contact
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    #[SerializedName('WhoId')]
    public ?string $whoId = null; // Contact or Lead ID

    #[SerializedName('WhatId')]
    public ?string $whatId = null; // Related object ID (Account, Opportunity, etc.)

    // Event Information
    #[SerializedName('Subject')]
    public ?string $subject = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('Location')]
    public ?string $location = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    // Date and Time
    #[SerializedName('StartDateTime')]
    public ?string $startDateTime = null;

    #[SerializedName('EndDateTime')]
    public ?string $endDateTime = null;

    #[SerializedName('DurationInMinutes')]
    public ?int $durationInMinutes = null;

    #[SerializedName('ActivityDate')]
    public ?string $activityDate = null;

    #[SerializedName('ActivityDateTime')]
    public ?string $activityDateTime = null;

    // All-Day Event
    #[SerializedName('IsAllDayEvent')]
    public ?bool $isAllDayEvent = null;

    // Reminder
    #[SerializedName('ReminderDateTime')]
    public ?string $reminderDateTime = null;

    #[SerializedName('IsReminderSet')]
    public ?bool $isReminderSet = null;

    // Private
    #[SerializedName('IsPrivate')]
    public ?bool $isPrivate = null;

    // Show As
    #[SerializedName('ShowAs')]
    public ?string $showAs = null;

    // Group Event
    #[SerializedName('IsGroupEvent')]
    public ?bool $isGroupEvent = null;

    #[SerializedName('GroupEventType')]
    public ?string $groupEventType = null;

    // Recurrence
    #[SerializedName('IsRecurrence')]
    public ?bool $isRecurrence = null;

    #[SerializedName('RecurrenceActivityId')]
    public ?string $recurrenceActivityId = null;

    #[SerializedName('RecurrenceStartDateTime')]
    public ?string $recurrenceStartDateTime = null;

    #[SerializedName('RecurrenceEndDateOnly')]
    public ?string $recurrenceEndDateOnly = null;

    #[SerializedName('RecurrenceType')]
    public ?string $recurrenceType = null;

    #[SerializedName('RecurrenceInterval')]
    public ?int $recurrenceInterval = null;

    #[SerializedName('RecurrenceDayOfWeekMask')]
    public ?int $recurrenceDayOfWeekMask = null;

    #[SerializedName('RecurrenceDayOfMonth')]
    public ?int $recurrenceDayOfMonth = null;

    #[SerializedName('RecurrenceInstance')]
    public ?string $recurrenceInstance = null;

    #[SerializedName('RecurrenceMonthOfYear')]
    public ?string $recurrenceMonthOfYear = null;

    #[SerializedName('RecurrenceTimeZoneSidKey')]
    public ?string $recurrenceTimeZoneSidKey = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Archived
    #[SerializedName('IsArchived')]
    public ?bool $isArchived = null;

    // Event Subtype
    #[SerializedName('EventSubtype')]
    public ?string $eventSubtype = null;
}
