<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Contact in Salesforce
 * A contact is an individual associated with an account
 */
class Contact extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('MasterRecordId')]
    public ?string $masterRecordId = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Account Association
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    // Name Fields
    #[SerializedName('Salutation')]
    public ?string $salutation = null;

    #[SerializedName('FirstName')]
    public ?string $firstName = null;

    #[SerializedName('LastName')]
    public ?string $lastName = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Suffix')]
    public ?string $suffix = null;

    // Professional Information
    #[SerializedName('Title')]
    public ?string $title = null;

    #[SerializedName('Department')]
    public ?string $department = null;

    #[SerializedName('AssistantName')]
    public ?string $assistantName = null;

    #[SerializedName('AssistantPhone')]
    public ?string $assistantPhone = null;

    // Contact Information
    #[SerializedName('Email')]
    public ?string $email = null;

    #[SerializedName('Phone')]
    public ?string $phone = null;

    #[SerializedName('HomePhone')]
    public ?string $homePhone = null;

    #[SerializedName('MobilePhone')]
    public ?string $mobilePhone = null;

    #[SerializedName('OtherPhone')]
    public ?string $otherPhone = null;

    #[SerializedName('Fax')]
    public ?string $fax = null;

    // Mailing Address
    #[SerializedName('MailingStreet')]
    public ?string $mailingStreet = null;

    #[SerializedName('MailingCity')]
    public ?string $mailingCity = null;

    #[SerializedName('MailingState')]
    public ?string $mailingState = null;

    #[SerializedName('MailingPostalCode')]
    public ?string $mailingPostalCode = null;

    #[SerializedName('MailingCountry')]
    public ?string $mailingCountry = null;

    #[SerializedName('MailingLatitude')]
    public ?float $mailingLatitude = null;

    #[SerializedName('MailingLongitude')]
    public ?float $mailingLongitude = null;

    #[SerializedName('MailingGeocodeAccuracy')]
    public ?string $mailingGeocodeAccuracy = null;

    // Other Address
    #[SerializedName('OtherStreet')]
    public ?string $otherStreet = null;

    #[SerializedName('OtherCity')]
    public ?string $otherCity = null;

    #[SerializedName('OtherState')]
    public ?string $otherState = null;

    #[SerializedName('OtherPostalCode')]
    public ?string $otherPostalCode = null;

    #[SerializedName('OtherCountry')]
    public ?string $otherCountry = null;

    #[SerializedName('OtherLatitude')]
    public ?float $otherLatitude = null;

    #[SerializedName('OtherLongitude')]
    public ?float $otherLongitude = null;

    #[SerializedName('OtherGeocodeAccuracy')]
    public ?string $otherGeocodeAccuracy = null;

    // Description
    #[SerializedName('Description')]
    public ?string $description = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastActivityDate')]
    public ?string $lastActivityDate = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Email Preferences
    #[SerializedName('EmailBouncedReason')]
    public ?string $emailBouncedReason = null;

    #[SerializedName('EmailBouncedDate')]
    public ?string $emailBouncedDate = null;

    #[SerializedName('HasOptedOutOfEmail')]
    public ?bool $hasOptedOutOfEmail = null;

    #[SerializedName('DoNotCall')]
    public ?bool $doNotCall = null;

    #[SerializedName('HasOptedOutOfFax')]
    public ?bool $hasOptedOutOfFax = null;

    // Additional Fields
    #[SerializedName('Birthdate')]
    public ?string $birthdate = null;

    #[SerializedName('LeadSource')]
    public ?string $leadSource = null;

    #[SerializedName('Level__c')]
    public ?string $level = null;

    #[SerializedName('Languages__c')]
    public ?string $languages = null;

    // Reports To
    #[SerializedName('ReportsToId')]
    public ?string $reportsToId = null;

    // Photo URL
    #[SerializedName('PhotoUrl')]
    public ?string $photoUrl = null;

    // Jigsaw
    #[SerializedName('Jigsaw')]
    public ?string $jigsaw = null;

    #[SerializedName('JigsawContactId')]
    public ?string $jigsawContactId = null;

    // Individual Email Result
    #[SerializedName('IndividualId')]
    public ?string $individualId = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
