<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Case in Salesforce
 * A case is a customer issue or problem
 */
class CaseModel extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('MasterRecordId')]
    public ?string $masterRecordId = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    #[SerializedName('CaseNumber')]
    public ?string $caseNumber = null;

    // Account and Contact
    #[SerializedName('AccountId')]
    public ?string $accountId = null;

    #[SerializedName('ContactId')]
    public ?string $contactId = null;

    // Contact Information
    #[SerializedName('ContactEmail')]
    public ?string $contactEmail = null;

    #[SerializedName('ContactPhone')]
    public ?string $contactPhone = null;

    #[SerializedName('ContactMobile')]
    public ?string $contactMobile = null;

    #[SerializedName('ContactFax')]
    public ?string $contactFax = null;

    // Case Information
    #[SerializedName('Subject')]
    public ?string $subject = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('Comments')]
    public ?string $comments = null;

    #[SerializedName('Status')]
    public ?string $status = null;

    #[SerializedName('Reason')]
    public ?string $reason = null;

    #[SerializedName('Origin')]
    public ?string $origin = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('Priority')]
    public ?string $priority = null;

    // Closure
    #[SerializedName('IsClosed')]
    public ?bool $isClosed = null;

    #[SerializedName('ClosedDate')]
    public ?string $closedDate = null;

    // Escalation
    #[SerializedName('IsEscalated')]
    public ?bool $isEscalated = null;

    // Web Information
    #[SerializedName('SuppliedEmail')]
    public ?string $suppliedEmail = null;

    #[SerializedName('SuppliedName')]
    public ?string $suppliedName = null;

    #[SerializedName('SuppliedPhone')]
    public ?string $suppliedPhone = null;

    #[SerializedName('SuppliedCompany')]
    public ?string $suppliedCompany = null;

    // Asset and Product
    #[SerializedName('AssetId')]
    public ?string $assetId = null;

    #[SerializedName('ProductId')]
    public ?string $productId = null;

    // Parent Case
    #[SerializedName('ParentId')]
    public ?string $parentId = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // SLA Fields
    #[SerializedName('SlaStartDate')]
    public ?string $slaStartDate = null;

    #[SerializedName('SlaExitDate')]
    public ?string $slaExitDate = null;

    // Entitlement
    #[SerializedName('EntitlementId')]
    public ?string $entitlementId = null;

    // Service Contract
    #[SerializedName('ServiceContractId')]
    public ?string $serviceContractId = null;

    // Business Hours
    #[SerializedName('BusinessHoursId')]
    public ?string $businessHoursId = null;

    // Milestone Status
    #[SerializedName('MilestoneStatus')]
    public ?string $milestoneStatus = null;

    #[SerializedName('MilestoneStatusIcon')]
    public ?string $milestoneStatusIcon = null;

    // Source
    #[SerializedName('SourceId')]
    public ?string $sourceId = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;

    /**
     * Override to return "Case" instead of "CaseModel"
     */
    public static function getSObjectType(): string
    {
        return 'Case';
    }
}
