<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents a Campaign in Salesforce
 * A campaign is a marketing project
 */
class Campaign extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Campaign Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('Status')]
    public ?string $status = null;

    // Parent Campaign
    #[SerializedName('ParentId')]
    public ?string $parentId = null;

    // Dates
    #[SerializedName('StartDate')]
    public ?string $startDate = null;

    #[SerializedName('EndDate')]
    public ?string $endDate = null;

    // Budget and Revenue
    #[SerializedName('ExpectedRevenue')]
    public ?float $expectedRevenue = null;

    #[SerializedName('BudgetedCost')]
    public ?float $budgetedCost = null;

    #[SerializedName('ActualCost')]
    public ?float $actualCost = null;

    #[SerializedName('ExpectedResponse')]
    public ?float $expectedResponse = null;

    #[SerializedName('AmountAllOpportunities')]
    public ?float $amountAllOpportunities = null;

    #[SerializedName('AmountWonOpportunities')]
    public ?float $amountWonOpportunities = null;

    // Counts
    #[SerializedName('NumberOfLeads')]
    public ?int $numberOfLeads = null;

    #[SerializedName('NumberOfConvertedLeads')]
    public ?int $numberOfConvertedLeads = null;

    #[SerializedName('NumberOfContacts')]
    public ?int $numberOfContacts = null;

    #[SerializedName('NumberOfOpportunities')]
    public ?int $numberOfOpportunities = null;

    #[SerializedName('NumberOfWonOpportunities')]
    public ?int $numberOfWonOpportunities = null;

    #[SerializedName('NumberOfResponses')]
    public ?int $numberOfResponses = null;

    #[SerializedName('NumberSent')]
    public ?float $numberSent = null;

    // Status Flags
    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Activity Fields
    #[SerializedName('LastActivityDate')]
    public ?string $lastActivityDate = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
