<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Attachment in Salesforce
 */
class Attachment extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    // Parent
    #[SerializedName('ParentId')]
    public ?string $parentId = null;

    // Attachment Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('ContentType')]
    public ?string $contentType = null;

    #[SerializedName('BodyLength')]
    public ?int $bodyLength = null;

    #[SerializedName('Body')]
    public ?string $body = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('IsPrivate')]
    public ?bool $isPrivate = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;
}
