<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models\Standard;

use SalesforceRestApi\Models\BaseModel;
use Symfony\Component\Serializer\Attribute\SerializedName;

/**
 * Represents an Account in Salesforce
 * An account is an organization or person involved with your business
 */
class Account extends BaseModel
{
    // System Fields
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('IsDeleted')]
    public ?bool $isDeleted = null;

    #[SerializedName('MasterRecordId')]
    public ?string $masterRecordId = null;

    #[SerializedName('RecordTypeId')]
    public ?string $recordTypeId = null;

    // Basic Information
    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('Type')]
    public ?string $type = null;

    #[SerializedName('ParentId')]
    public ?string $parentId = null;

    #[SerializedName('Industry')]
    public ?string $industry = null;

    #[SerializedName('AnnualRevenue')]
    public ?float $annualRevenue = null;

    #[SerializedName('NumberOfEmployees')]
    public ?int $numberOfEmployees = null;

    #[SerializedName('Ownership')]
    public ?string $ownership = null;

    // Contact Information
    #[SerializedName('Website')]
    public ?string $website = null;

    #[SerializedName('Phone')]
    public ?string $phone = null;

    #[SerializedName('Fax')]
    public ?string $fax = null;

    // Billing Address
    #[SerializedName('BillingStreet')]
    public ?string $billingStreet = null;

    #[SerializedName('BillingCity')]
    public ?string $billingCity = null;

    #[SerializedName('BillingState')]
    public ?string $billingState = null;

    #[SerializedName('BillingPostalCode')]
    public ?string $billingPostalCode = null;

    #[SerializedName('BillingCountry')]
    public ?string $billingCountry = null;

    #[SerializedName('BillingLatitude')]
    public ?float $billingLatitude = null;

    #[SerializedName('BillingLongitude')]
    public ?float $billingLongitude = null;

    #[SerializedName('BillingGeocodeAccuracy')]
    public ?string $billingGeocodeAccuracy = null;

    // Shipping Address
    #[SerializedName('ShippingStreet')]
    public ?string $shippingStreet = null;

    #[SerializedName('ShippingCity')]
    public ?string $shippingCity = null;

    #[SerializedName('ShippingState')]
    public ?string $shippingState = null;

    #[SerializedName('ShippingPostalCode')]
    public ?string $shippingPostalCode = null;

    #[SerializedName('ShippingCountry')]
    public ?string $shippingCountry = null;

    #[SerializedName('ShippingLatitude')]
    public ?float $shippingLatitude = null;

    #[SerializedName('ShippingLongitude')]
    public ?float $shippingLongitude = null;

    #[SerializedName('ShippingGeocodeAccuracy')]
    public ?string $shippingGeocodeAccuracy = null;

    // Description
    #[SerializedName('Description')]
    public ?string $description = null;

    // Ownership Information
    #[SerializedName('OwnerId')]
    public ?string $ownerId = null;

    #[SerializedName('CreatedDate')]
    public ?string $createdDate = null;

    #[SerializedName('CreatedById')]
    public ?string $createdById = null;

    #[SerializedName('LastModifiedDate')]
    public ?string $lastModifiedDate = null;

    #[SerializedName('LastModifiedById')]
    public ?string $lastModifiedById = null;

    #[SerializedName('SystemModstamp')]
    public ?string $systemModstamp = null;

    // Additional Fields
    #[SerializedName('AccountNumber')]
    public ?string $accountNumber = null;

    #[SerializedName('Site')]
    public ?string $site = null;

    #[SerializedName('TickerSymbol')]
    public ?string $tickerSymbol = null;

    #[SerializedName('Rating')]
    public ?string $rating = null;

    #[SerializedName('AccountSource')]
    public ?string $accountSource = null;

    #[SerializedName('SicDesc')]
    public ?string $sicDesc = null;

    // Activity Fields
    #[SerializedName('LastActivityDate')]
    public ?string $lastActivityDate = null;

    #[SerializedName('LastViewedDate')]
    public ?string $lastViewedDate = null;

    #[SerializedName('LastReferencedDate')]
    public ?string $lastReferencedDate = null;

    // Jigsaw Fields
    #[SerializedName('Jigsaw')]
    public ?string $jigsaw = null;

    #[SerializedName('JigsawCompanyId')]
    public ?string $jigsawCompanyId = null;

    // Photo URL
    #[SerializedName('PhotoUrl')]
    public ?string $photoUrl = null;

    // Related Objects
    #[SerializedName('RecordType')]
    public ?array $recordType = null;
}
