<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models;

use Symfony\Component\Serializer\Attribute\SerializedName;

class SObjectRecord extends BaseModel
{
    #[SerializedName('Id')]
    public ?string $id = null;

    public ?string $type = null;

    public ?array $attributes = null;

    /**
     * Additional hydration after Symfony Serializer
     * Handles case variations and extracts type from attributes
     */
    protected function hydrate(array $data): void
    {
        // Handle 'id' vs 'Id' case sensitivity
        if ($this->id === null) {
            $this->id = $data['id'] ?? null;
        }

        // Extract type from attributes if available
        if ($this->attributes && isset($this->attributes['type'])) {
            $this->type = $this->attributes['type'];
        }
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function getAttributes(): ?array
    {
        return $this->attributes;
    }

    /**
     * Get a specific field value from raw data
     */
    public function getField(string $fieldName): mixed
    {
        return $this->get($fieldName);
    }
}
