<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models;

use Symfony\Component\Serializer\Attribute\SerializedName;

class RecordType extends BaseModel
{
    #[SerializedName('Id')]
    public ?string $id = null;

    #[SerializedName('Name')]
    public ?string $name = null;

    #[SerializedName('DeveloperName')]
    public ?string $developerName = null;

    #[SerializedName('Description')]
    public ?string $description = null;

    #[SerializedName('IsActive')]
    public ?bool $isActive = null;

    #[SerializedName('SobjectType')]
    public ?string $sobjectType = null;

    #[SerializedName('BusinessProcessId')]
    public ?string $businessProcessId = null;

    #[SerializedName('NamespacePrefix')]
    public ?string $namespacePrefix = null;

    #[SerializedName('IsPersonType')]
    public ?bool $isPersonType = null;

    public ?array $attributes = null;

    /**
     * Additional hydration after Symfony Serializer
     * Handles case variations
     */
    protected function hydrate(array $data): void
    {
        // Handle case sensitivity variations
        if ($this->id === null) {
            $this->id = $data['id'] ?? null;
        }
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getDeveloperName(): ?string
    {
        return $this->developerName;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function isActive(): ?bool
    {
        return $this->isActive;
    }

    public function getSobjectType(): ?string
    {
        return $this->sobjectType;
    }

    public function getBusinessProcessId(): ?string
    {
        return $this->businessProcessId;
    }

    public function getNamespacePrefix(): ?string
    {
        return $this->namespacePrefix;
    }

    public function isPersonType(): ?bool
    {
        return $this->isPersonType;
    }

    public function getAttributes(): ?array
    {
        return $this->attributes;
    }
}
