<?php

declare(strict_types=1);

namespace SalesforceRestApi\Models;

class QueryResult extends BaseModel
{
    public int $totalSize = 0;

    public bool $done = true;

    public ?string $nextRecordsUrl = null;

    /**
     * @var array<int, SObjectRecord>
     */
    public array $records = [];

    /**
     * Additional hydration to convert record arrays to SObjectRecord instances
     * Symfony Serializer handles the basic properties, this handles nested objects
     */
    protected function hydrate(array $data): void
    {
        // Convert records array to SObjectRecord instances
        if (isset($data['records']) && is_array($data['records'])) {
            $this->records = array_map(
                fn(array $record) => SObjectRecord::fromArray($record),
                $data['records']
            );
        }
    }

    public function getTotalSize(): int
    {
        return $this->totalSize;
    }

    public function isDone(): bool
    {
        return $this->done;
    }

    public function getNextRecordsUrl(): ?string
    {
        return $this->nextRecordsUrl;
    }

    /**
     * @return array<int, SObjectRecord>
     */
    public function getRecords(): array
    {
        return $this->records;
    }
}
